/*
 * Decompiled with CFR 0.152.
 */
package Coloryr.AllMusic.player.decoder.mp3;

import Coloryr.AllMusic.player.decoder.mp3.BitstreamErrors;
import Coloryr.AllMusic.player.decoder.mp3.BitstreamException;
import Coloryr.AllMusic.player.decoder.mp3.Crc16;
import Coloryr.AllMusic.player.decoder.mp3.Header;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.SocketException;
import java.net.URL;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public final class Bitstream
implements BitstreamErrors {
    private static final int BUFFER_INT_SIZE = 433;
    static byte INITIAL_SYNC = 0;
    static byte STRICT_SYNC = 1;
    private final int[] framebuffer = new int[433];
    private final int[] bitmask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071};
    private final Header header = new Header();
    private final byte[] syncbuf = new byte[4];
    private final byte[] frame_bytes = new byte[1732];
    private final Crc16[] crc = new Crc16[1];
    private HttpGet get;
    private final HttpClient client;
    private final URL url;
    private PushbackInputStream source;
    private long local = 0L;
    private int framesize;
    private int wordpointer;
    private int bitindex;
    private int syncword;
    private boolean single_ch_mode;
    private byte[] rawid3v2 = null;
    private boolean firstframe = true;
    private InputStream content;

    public Bitstream(HttpClient client, URL url) throws Exception {
        this.client = client;
        this.url = url;
        this.get = new HttpGet(url.toString());
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
        this.get.setConfig(requestConfig);
        HttpResponse response = this.client.execute((HttpUriRequest)this.get);
        HttpEntity entity = response.getEntity();
        this.content = entity.getContent();
        this.content = new BufferedInputStream(this.content);
        this.loadID3v2(this.content);
        this.firstframe = true;
        this.source = new PushbackInputStream(this.content, 1732);
        this.closeFrame();
    }

    public int getframesize() {
        return this.framesize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadID3v2(InputStream in) {
        int size = -1;
        try {
            in.mark(10);
            this.local += 10L;
            int n = size = this.readID3v2Header(in);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                in.reset();
            }
            catch (IOException iOException) {}
        }
        try {
            if (size > 0) {
                this.rawid3v2 = new byte[size];
                in.read(this.rawid3v2, 0, this.rawid3v2.length);
                this.local += (long)this.rawid3v2.length;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int readID3v2Header(InputStream in) throws IOException {
        byte[] id3header = new byte[4];
        int size = -10;
        in.read(id3header, 0, 3);
        if (id3header[0] == 73 && id3header[1] == 68 && id3header[2] == 51) {
            in.read(id3header, 0, 3);
            in.read(id3header, 0, 4);
            size = (id3header[0] << 21) + (id3header[1] << 14) + (id3header[2] << 7) + id3header[3];
        }
        return size + 10;
    }

    public InputStream getRawID3v2() {
        if (this.rawid3v2 == null) {
            return null;
        }
        return new ByteArrayInputStream(this.rawid3v2);
    }

    public void close() throws BitstreamException {
        try {
            this.get.abort();
            this.content.close();
            this.source.close();
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
    }

    public Header readFrame() throws Exception {
        Header result;
        block7: {
            result = null;
            try {
                result = this.readNextFrame();
                if (this.firstframe) {
                    result.parseVBR(this.frame_bytes);
                    this.firstframe = false;
                }
            }
            catch (BitstreamException ex) {
                if (ex.getErrorCode() == 261) {
                    try {
                        this.closeFrame();
                        result = this.readNextFrame();
                    }
                    catch (BitstreamException e) {
                        if (e.getErrorCode() != 260) {
                            throw this.newBitstreamException(e.getErrorCode(), e);
                        }
                        break block7;
                    }
                }
                if (ex.getErrorCode() == 260) break block7;
                throw this.newBitstreamException(ex.getErrorCode(), ex);
            }
        }
        return result;
    }

    private Header readNextFrame() throws Exception {
        if (this.framesize == -1) {
            this.nextFrame();
        }
        return this.header;
    }

    private void nextFrame() throws Exception {
        this.header.read_header(this, this.crc);
    }

    public void unreadFrame() throws BitstreamException {
        if (this.wordpointer == -1 && this.bitindex == -1 && this.framesize > 0) {
            try {
                this.source.unread(this.frame_bytes, 0, this.framesize);
                this.local -= (long)this.framesize;
            }
            catch (IOException ex) {
                throw this.newBitstreamException(258);
            }
        }
    }

    public void closeFrame() {
        this.framesize = -1;
        this.wordpointer = -1;
        this.bitindex = -1;
    }

    public boolean isSyncCurrentPosition(int syncmode) throws Exception {
        int read = this.readBytes(this.syncbuf, 0, 4);
        int headerstring = this.syncbuf[0] << 24 & 0xFF000000 | this.syncbuf[1] << 16 & 0xFF0000 | this.syncbuf[2] << 8 & 0xFF00 | this.syncbuf[3] & 0xFF;
        try {
            this.source.unread(this.syncbuf, 0, read);
            this.local -= (long)read;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        boolean sync = false;
        switch (read) {
            case 0: {
                sync = true;
                break;
            }
            case 4: {
                sync = this.isSyncMark(headerstring, syncmode, this.syncword);
            }
        }
        return sync;
    }

    protected BitstreamException newBitstreamException(int errorcode) {
        return new BitstreamException(errorcode, null);
    }

    protected BitstreamException newBitstreamException(int errorcode, Throwable throwable) {
        return new BitstreamException(errorcode, throwable);
    }

    int syncHeader(byte syncmode) throws Exception {
        boolean sync;
        int bytesRead = this.readBytes(this.syncbuf, 0, 3);
        if (bytesRead != 3) {
            throw this.newBitstreamException(260, null);
        }
        int headerstring = this.syncbuf[0] << 16 & 0xFF0000 | this.syncbuf[1] << 8 & 0xFF00 | this.syncbuf[2] & 0xFF;
        do {
            headerstring <<= 8;
            if (this.readBytes(this.syncbuf, 3, 1) == 1) continue;
            throw this.newBitstreamException(260, null);
        } while (!(sync = this.isSyncMark(headerstring |= this.syncbuf[3] & 0xFF, syncmode, this.syncword)));
        return headerstring;
    }

    public boolean isSyncMark(int headerstring, int syncmode, int word) {
        boolean sync;
        if (syncmode == INITIAL_SYNC) {
            sync = (headerstring & 0xFFE00000) == -2097152;
        } else {
            boolean bl = (headerstring & 0xFFF80C00) == word && (headerstring & 0xC0) == 192 == this.single_ch_mode ? true : (sync = false);
        }
        if (sync) {
            boolean bl = sync = (headerstring >>> 10 & 3) != 3;
        }
        if (sync) {
            boolean bl = sync = (headerstring >>> 17 & 3) != 0;
        }
        if (sync) {
            sync = (headerstring >>> 19 & 3) != 1;
        }
        return sync;
    }

    int read_frame_data(int bytesize) throws Exception {
        int numread = this.readFully(this.frame_bytes, 0, bytesize);
        this.framesize = bytesize;
        this.wordpointer = -1;
        this.bitindex = -1;
        return numread;
    }

    void parse_frame() {
        int b = 0;
        byte[] byteread = this.frame_bytes;
        int bytesize = this.framesize;
        for (int k = 0; k < bytesize; k += 4) {
            byte b1 = 0;
            byte b2 = 0;
            byte b3 = 0;
            byte b0 = byteread[k];
            if (k + 1 < bytesize) {
                b1 = byteread[k + 1];
            }
            if (k + 2 < bytesize) {
                b2 = byteread[k + 2];
            }
            if (k + 3 < bytesize) {
                b3 = byteread[k + 3];
            }
            this.framebuffer[b++] = b0 << 24 & 0xFF000000 | b1 << 16 & 0xFF0000 | b2 << 8 & 0xFF00 | b3 & 0xFF;
        }
        this.wordpointer = 0;
        this.bitindex = 0;
    }

    public int get_bits(int number_of_bits) {
        int sum = this.bitindex + number_of_bits;
        if (this.wordpointer < 0) {
            this.wordpointer = 0;
        }
        if (sum <= 32) {
            int returnvalue = this.framebuffer[this.wordpointer] >>> 32 - sum & this.bitmask[number_of_bits];
            if ((this.bitindex += number_of_bits) == 32) {
                this.bitindex = 0;
                ++this.wordpointer;
            }
            return returnvalue;
        }
        int Right = this.framebuffer[this.wordpointer] & 0xFFFF;
        ++this.wordpointer;
        int Left = this.framebuffer[this.wordpointer] & 0xFFFF0000;
        int returnvalue = Right << 16 & 0xFFFF0000 | Left >>> 16 & 0xFFFF;
        returnvalue >>>= 48 - sum;
        this.bitindex = sum - 32;
        return returnvalue &= this.bitmask[number_of_bits];
    }

    void set_syncword(int syncword0) {
        this.syncword = syncword0 & 0xFFFFFF3F;
        this.single_ch_mode = (syncword0 & 0xC0) == 192;
    }

    private int readFully(byte[] b, int offs, int len) throws Exception {
        int nRead = 0;
        try {
            while (len > 0) {
                int bytesread = this.source.read(b, offs, len);
                this.local += (long)bytesread;
                if (bytesread == -1) {
                    while (len-- > 0) {
                        b[offs++] = 0;
                    }
                    break;
                }
                nRead += bytesread;
                offs += bytesread;
                len -= bytesread;
            }
        }
        catch (SocketException | ConnectionClosedException ex) {
            this.get.setHeader("Range", "bytes=" + this.local + "-");
            HttpResponse response = this.client.execute((HttpUriRequest)this.get);
            HttpEntity entity = response.getEntity();
            this.content = entity.getContent();
            this.source = new PushbackInputStream(this.content, 1732);
            return this.readFully(b, offs, len);
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
        return nRead;
    }

    private int readBytes(byte[] b, int offs, int len) throws Exception {
        int totalBytesRead = 0;
        try {
            while (len > 0) {
                int bytesread = this.source.read(b, offs, len);
                this.local += (long)bytesread;
                if (bytesread != -1) {
                    totalBytesRead += bytesread;
                    offs += bytesread;
                    len -= bytesread;
                    continue;
                }
                break;
            }
        }
        catch (SocketException | ConnectionClosedException ex) {
            this.get.setHeader("Range", "bytes=" + this.local + "-");
            HttpResponse response = this.client.execute((HttpUriRequest)this.get);
            HttpEntity entity = response.getEntity();
            this.content = entity.getContent();
            this.source = new PushbackInputStream(this.content, 1732);
            return this.readBytes(b, offs, len);
        }
        catch (IOException ex) {
            throw this.newBitstreamException(258, ex);
        }
        return totalBytesRead;
    }

    public void setLocal(long local) {
        try {
            this.get.abort();
            this.get = new HttpGet(this.url.toString());
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).build();
            this.get.setConfig(requestConfig);
            this.local = local;
            this.get.setHeader("Range", "bytes=" + local + "-");
            HttpResponse response = this.client.execute((HttpUriRequest)this.get);
            HttpEntity entity = response.getEntity();
            this.content = entity.getContent();
            this.source = new PushbackInputStream(this.content, 1732);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

