/*
 * Decompiled with CFR 0.152.
 */
package Coloryr.AllMusic.player.decoder.flac;

import Coloryr.AllMusic.player.decoder.flac.ByteArrayFlacInput;
import Coloryr.AllMusic.player.decoder.flac.DataFormatException;
import Coloryr.AllMusic.player.decoder.flac.FrameInfo;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;

public final class StreamInfo {
    public int minBlockSize;
    public int maxBlockSize;
    public int minFrameSize;
    public int maxFrameSize;
    public int sampleRate;
    public int numChannels;
    public int sampleDepth;
    public long numSamples;
    public byte[] md5Hash;

    public StreamInfo() {
        this.minFrameSize = 0;
        this.maxFrameSize = 0;
        this.numSamples = 0L;
        this.md5Hash = new byte[16];
        this.minBlockSize = 0;
        this.maxBlockSize = 0;
        this.sampleRate = 0;
    }

    public StreamInfo(byte[] b) {
        Objects.requireNonNull(b);
        if (b.length != 34) {
            throw new IllegalArgumentException("Invalid data length");
        }
        try {
            ByteArrayFlacInput in = new ByteArrayFlacInput(b);
            this.minBlockSize = in.readUint(16);
            this.maxBlockSize = in.readUint(16);
            this.minFrameSize = in.readUint(24);
            this.maxFrameSize = in.readUint(24);
            if (this.minBlockSize < 16) {
                throw new DataFormatException("Minimum block size less than 16");
            }
            if (this.maxBlockSize > 65535) {
                throw new DataFormatException("Maximum block size greater than 65535");
            }
            if (this.maxBlockSize < this.minBlockSize) {
                throw new DataFormatException("Maximum block size less than minimum block size");
            }
            if (this.minFrameSize != 0 && this.maxFrameSize != 0 && this.maxFrameSize < this.minFrameSize) {
                throw new DataFormatException("Maximum frame size less than minimum frame size");
            }
            this.sampleRate = in.readUint(20);
            if (this.sampleRate == 0 || this.sampleRate > 655350) {
                throw new DataFormatException("Invalid sample rate");
            }
            this.numChannels = in.readUint(3) + 1;
            this.sampleDepth = in.readUint(5) + 1;
            this.numSamples = (long)in.readUint(18) << 18 | (long)in.readUint(18);
            this.md5Hash = new byte[16];
            in.readFully(this.md5Hash);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void checkValues() {
        if (this.minBlockSize >>> 16 != 0) {
            throw new IllegalStateException("Invalid minimum block size");
        }
        if (this.maxBlockSize >>> 16 != 0) {
            throw new IllegalStateException("Invalid maximum block size");
        }
        if (this.minFrameSize >>> 24 != 0) {
            throw new IllegalStateException("Invalid minimum frame size");
        }
        if (this.maxFrameSize >>> 24 != 0) {
            throw new IllegalStateException("Invalid maximum frame size");
        }
        if (this.sampleRate == 0 || this.sampleRate >>> 20 != 0) {
            throw new IllegalStateException("Invalid sample rate");
        }
        if (this.numChannels < 1 || this.numChannels > 8) {
            throw new IllegalStateException("Invalid number of channels");
        }
        if (this.sampleDepth < 4 || this.sampleDepth > 32) {
            throw new IllegalStateException("Invalid sample depth");
        }
        if (this.numSamples >>> 36 != 0L) {
            throw new IllegalStateException("Invalid number of samples");
        }
        Objects.requireNonNull(this.md5Hash);
        if (this.md5Hash.length != 16) {
            throw new IllegalStateException("Invalid MD5 hash length");
        }
    }

    public void checkFrame(FrameInfo meta) {
        if (meta.numChannels != this.numChannels) {
            throw new DataFormatException("Channel count mismatch");
        }
        if (meta.sampleRate != -1 && meta.sampleRate != this.sampleRate) {
            throw new DataFormatException("Sample rate mismatch");
        }
        if (meta.sampleDepth != -1 && meta.sampleDepth != this.sampleDepth) {
            throw new DataFormatException("Sample depth mismatch");
        }
        if (this.numSamples != 0L && (long)meta.blockSize > this.numSamples) {
            throw new DataFormatException("Block size exceeds total number of samples");
        }
        if (meta.blockSize > this.maxBlockSize) {
            throw new DataFormatException("Block size exceeds maximum");
        }
        if (this.minFrameSize != 0 && meta.frameSize < this.minFrameSize) {
            throw new DataFormatException("Frame size less than minimum");
        }
        if (this.maxFrameSize != 0 && meta.frameSize > this.maxFrameSize) {
            throw new DataFormatException("Frame size exceeds maximum");
        }
    }

    public static byte[] getMd5Hash(int[][] samples, int depth) {
        MessageDigest hasher;
        Objects.requireNonNull(samples);
        for (int[] chanSamples : samples) {
            Objects.requireNonNull(chanSamples);
        }
        if (depth < 0 || depth > 32 || depth % 8 != 0) {
            throw new IllegalArgumentException("Unsupported bit depth");
        }
        try {
            hasher = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        int numChannels = samples.length;
        int numSamples = samples[0].length;
        int numBytes = depth / 8;
        byte[] buf = new byte[numChannels * numBytes * Math.min(numSamples, 2048)];
        int l = 0;
        for (int i = 0; i < numSamples; ++i) {
            for (int j = 0; j < numChannels; ++j) {
                int val = samples[j][i];
                int k = 0;
                while (k < numBytes) {
                    buf[l] = (byte)(val >>> (k << 3));
                    ++k;
                    ++l;
                }
            }
            if (l != buf.length && i != numSamples - 1) continue;
            hasher.update(buf, 0, l);
            l = 0;
        }
        return hasher.digest();
    }
}

