/*
 * Decompiled with CFR 0.152.
 */
package com.locydragon.mod.abf;

import com.locydragon.mod.abf.Info;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javazoom.jl.player.Player;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="audiobuffer", version="1.0.0", acceptedMinecraftVersions="(,1.8)")
public class AudioBuffer {
    static final String MODID = "audiobuffer";
    static final String VERSION = "1.0.0";
    public static Float volume;
    public static FMLEventChannel channel;
    public static FMLEventChannel output;
    public static Player nowPlaying;
    public static URL nowURL;
    public static File localLocation;
    public static Info info;
    public static ConcurrentLinkedQueue<Player> playerList;

    @Mod.EventHandler
    public void preload(FMLPreInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("AudioBuffer");
        channel.register((Object)this);
        output = NetworkRegistry.INSTANCE.newEventDrivenChannel("AudioBufferOut");
        output.register((Object)this);
    }

    @SubscribeEvent
    public void onServerQuit(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
        if (nowPlaying != null && !nowPlaying.isComplete()) {
            nowPlaying.close();
            nowPlaying = null;
            nowURL = null;
        }
    }

    @SubscribeEvent
    public void onClicentPacket(final FMLNetworkEvent.ClientCustomPacketEvent evt) {
        Thread asyncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                byte[] array = evt.packet.payload().array();
                String message = new String(array);
                if (message.equals("[Stop]")) {
                    AudioBuffer.this.stopPlaying();
                } else if (message.startsWith("[Net]")) {
                    if (nowPlaying != null) {
                        playerList.add(nowPlaying);
                    }
                    try {
                        nowURL = new URL(message.replace("[Net]", ""));
                        Player player = new Player(nowURL.openStream());
                        playerList.add(player);
                        nowPlaying = player;
                        player.play();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (message.startsWith("[Volume]")) {
                    AudioBuffer.this.stopPlaying();
                    AudioBuffer.this.setGain(Float.valueOf(message.replace("[Volume]", "")).floatValue());
                } else if (message.startsWith("[Has]")) {
                    message = message.replace("[Has]", "");
                    String time = message.split("\\*")[0];
                    String name = message.split("\\*")[1];
                    File targetFile = new File(".//AudioBuffer//" + name);
                    if (targetFile.exists()) {
                        byte[] info = new String(time + "*true").getBytes();
                        ByteBuf buf = Unpooled.wrappedBuffer((byte[])info);
                        output.sendToServer(new FMLProxyPacket((ByteBuf)new PacketBuffer(buf), "AudioBufferOut"));
                    } else {
                        byte[] info = new String(time + "*false").getBytes();
                        ByteBuf buf = Unpooled.wrappedBuffer((byte[])info);
                        output.sendToServer(new FMLProxyPacket((ByteBuf)new PacketBuffer(buf), "AudioBufferOut"));
                    }
                } else if (message.startsWith("[Local]")) {
                    message = message.replace("[Local]", "");
                    File targetFile = new File(".//AudioBuffer//" + message);
                    if (nowPlaying != null) {
                        playerList.add(nowPlaying);
                    }
                    try {
                        nowURL = targetFile.toURI().toURL();
                        Player player = new Player(nowURL.openStream());
                        playerList.add(player);
                        nowPlaying = player;
                        player.play();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (message.startsWith("[Download]")) {
                    message = message.replace("[Download]", "");
                    AudioBuffer.info.next = true;
                    AudioBuffer.info.name = message;
                } else if (AudioBuffer.info.next) {
                    AudioBuffer.info.next = false;
                    String fileName = AudioBuffer.info.name;
                    AudioBuffer.info.name = null;
                    File targetFile = new File(".//AudioBuffer//" + fileName);
                    if (!targetFile.exists()) {
                        try {
                            targetFile.createNewFile();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        try {
                            FileOutputStream stream = new FileOutputStream(targetFile);
                            stream.write(array);
                            stream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        asyncThread.start();
    }

    public void setGain(float ctrl) {
        if (ctrl > 1.0f) {
            ctrl /= 100.0f;
        }
        try {
            Mixer.Info[] infos;
            for (Mixer.Info info : infos = AudioSystem.getMixerInfo()) {
                Mixer mixer = AudioSystem.getMixer(info);
                if (!mixer.isLineSupported(Port.Info.SPEAKER)) continue;
                Port port = (Port)mixer.getLine(Port.Info.SPEAKER);
                port.open();
                if (port.isControlSupported(FloatControl.Type.VOLUME)) {
                    FloatControl volume = (FloatControl)port.getControl(FloatControl.Type.VOLUME);
                    volume.setValue(ctrl);
                    AudioBuffer.volume = Float.valueOf(ctrl);
                }
                port.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stopPlaying() {
        for (Player player : playerList) {
            player.close();
        }
        playerList.clear();
    }

    static {
        nowPlaying = null;
        nowURL = null;
        localLocation = null;
        info = new Info();
        playerList = new ConcurrentLinkedQueue();
        localLocation = new File(".//AudioBuffer//");
        File readMe = new File(".//AudioBuffer//Null.test");
        if (!readMe.exists()) {
            readMe.getParentFile().mkdirs();
            try {
                readMe.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

