unit MC_CRYPT;

interface
uses
{$IFDEF WIN32}
  Windows;
{$ELSE}
  Wintypes, WinProcs;
{$ENDIF}

const
  CRYPT_OK = 0; {//ɹ}
  CRYPT_EOR = -1; {//ע}
  CRYPT_EOL = -2; {//ַ볤ȴ}
  CRYPT_EOC = -3; {//Чַ}
  CRYPT_EON = -4; {//Чֵ}

var
  Register: function(lpRegisterCode: PChar): Integer; stdcall; 
  DESEncrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  DESDecrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  Base64Encode: function(lpInput: PChar; lpOutput: PChar): Integer; stdcall; 
  Base64Decode: function(lpInput: PChar; lpOutput: PChar): Integer; stdcall; 
  BlowFishEncrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  BlowFishDecrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  AESEncrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  AESDecrypt: function(lpInput: PChar; lpKey: PChar; lpOutput: PChar): Integer; stdcall; 
  MD5Encrypt: function(lpInput: PChar; lpOutput: PChar): Integer; stdcall; 
  SHAEncrypt: function(lpInput: PChar; lpOutput: PChar): Integer; stdcall; 
  RSAMakeKey: function(Mode: Integer; lpN: PChar; lpD: PChar): Integer; stdcall; 
  RSAEncrypt: function(lpInput: PChar; lpN: PChar; lpOutput: PChar): Integer; stdcall; 
  RSADecrypt: function(lpInput: PChar; lpN: PChar; lpD: PChar; lpOutput: PChar): Integer; stdcall; 

var
  DLLLoaded: Boolean { is DLL (dynamically) loaded already? }
    {$IFDEF WIN32} = False; {$ENDIF}

implementation

var
  SaveExit: pointer;
  DLLHandle: THandle;
{$IFNDEF MSDOS}
  ErrorMode: Integer;
{$ENDIF}

  procedure NewExit; far;
  begin
    ExitProc := SaveExit;
    FreeLibrary(DLLHandle)
  end {NewExit};

procedure LoadDLL;
begin
  if DLLLoaded then Exit;
{$IFNDEF MSDOS}
  ErrorMode := SetErrorMode($8000{SEM_NoOpenFileErrorBox});
{$ENDIF}
  DLLHandle := LoadLibrary('MC_CRYPT.DLL');
  if DLLHandle >= 32 then
  begin
    DLLLoaded := True;
    SaveExit := ExitProc;
    ExitProc := @NewExit;
    @Register := GetProcAddress(DLLHandle,'Register');
  {$IFDEF WIN32}
    Assert(@Register <> nil);
  {$ENDIF}
    @DESEncrypt := GetProcAddress(DLLHandle,'DESEncrypt');
  {$IFDEF WIN32}
    Assert(@DESEncrypt <> nil);
  {$ENDIF}
    @DESDecrypt := GetProcAddress(DLLHandle,'DESDecrypt');
  {$IFDEF WIN32}
    Assert(@DESDecrypt <> nil);
  {$ENDIF}
    @Base64Encode := GetProcAddress(DLLHandle,'Base64Encode');
  {$IFDEF WIN32}
    Assert(@Base64Encode <> nil);
  {$ENDIF}
    @Base64Decode := GetProcAddress(DLLHandle,'Base64Decode');
  {$IFDEF WIN32}
    Assert(@Base64Decode <> nil);
  {$ENDIF}
    @BlowFishEncrypt := GetProcAddress(DLLHandle,'BlowFishEncrypt');
  {$IFDEF WIN32}
    Assert(@BlowFishEncrypt <> nil);
  {$ENDIF}
    @BlowFishDecrypt := GetProcAddress(DLLHandle,'BlowFishDecrypt');
  {$IFDEF WIN32}
    Assert(@BlowFishDecrypt <> nil);
  {$ENDIF}
    @AESEncrypt := GetProcAddress(DLLHandle,'AESEncrypt');
  {$IFDEF WIN32}
    Assert(@AESEncrypt <> nil);
  {$ENDIF}
    @AESDecrypt := GetProcAddress(DLLHandle,'AESDecrypt');
  {$IFDEF WIN32}
    Assert(@AESDecrypt <> nil);
  {$ENDIF}
    @MD5Encrypt := GetProcAddress(DLLHandle,'MD5Encrypt');
  {$IFDEF WIN32}
    Assert(@MD5Encrypt <> nil);
  {$ENDIF}
    @SHAEncrypt := GetProcAddress(DLLHandle,'SHAEncrypt');
  {$IFDEF WIN32}
    Assert(@SHAEncrypt <> nil);
  {$ENDIF}
    @RSAMakeKey := GetProcAddress(DLLHandle,'RSAMakeKey');
  {$IFDEF WIN32}
    Assert(@RSAMakeKey <> nil);
  {$ENDIF}
    @RSAEncrypt := GetProcAddress(DLLHandle,'RSAEncrypt');
  {$IFDEF WIN32}
    Assert(@RSAEncrypt <> nil);
  {$ENDIF}
    @RSADecrypt := GetProcAddress(DLLHandle,'RSADecrypt');
  {$IFDEF WIN32}
    Assert(@RSADecrypt <> nil);
  {$ENDIF}
  end
  else
  begin
    DLLLoaded := False;
    { Error: MC_CRYPT.DLL could not be loaded !! }
  end;
{$IFNDEF MSDOS}
  SetErrorMode(ErrorMode)
{$ENDIF}
end {LoadDLL};

begin
  LoadDLL;
end.
