/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.keystrokes.config;

import club.sk1er.mods.keystrokes.Keystrokes;
import club.sk1er.mods.keystrokes.keys.custom.CustomKeyWrapper;
import club.sk1er.mods.keystrokes.keys.types.CustomKey;
import club.sk1er.mods.keystrokes.util.BetterJsonObject;
import club.sk1er.mods.keystrokes.util.prod.JsonHolder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.apache.logging.log4j.LogManager;

public class KeystrokesSettings {
    public static final int SNEAK_HEIGHT = 18;
    private final Keystrokes keystrokes;
    private final File configFile;
    private int x;
    private int y;
    private boolean enabled = true;
    private boolean chroma;
    private boolean mouseButtons;
    private boolean showCPS;
    private boolean showCPSOnButtons;
    private boolean showSpacebar;
    private boolean showFPS;
    private double scale = 1.0;
    private double fadeTime = 1.0;
    private int red = 255;
    private int green = 255;
    private int blue = 255;
    private int pressedRed;
    private int pressedGreen;
    private int pressedBlue;
    private boolean leftClick = true;
    private boolean showingSneak;
    private boolean keyBackground;
    private boolean showWASD = true;
    private boolean literalKeys;
    private int keyBackgroundOpacity = 120;
    private int keyBackgroundRed;
    private int keyBackgroundGreen;
    private int keyBackgroundBlue;
    private boolean arrowKeys;
    private List<CustomKeyWrapper> customKeyWrappers = new ArrayList<CustomKeyWrapper>();

    public KeystrokesSettings(Keystrokes keystrokes, File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.keystrokes = keystrokes;
        this.configFile = new File(directory, "keystrokes.json");
    }

    public void load() {
        try {
            if (!this.configFile.getParentFile().exists() || !this.configFile.exists()) {
                this.save();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
            List options = reader.lines().collect(Collectors.toList());
            if (options.isEmpty()) {
                return;
            }
            String builder = String.join((CharSequence)"", options);
            if (builder.trim().length() > 0) {
                this.parseSettings(new BetterJsonObject(builder.trim()));
            }
        }
        catch (Exception e) {
            LogManager.getLogger((String)"Keystrokes").error("Could not load config file! {}", (Object)this.configFile.getName(), (Object)e);
            this.save();
        }
    }

    public void save() {
        try {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            if (!this.configFile.exists() && !this.configFile.createNewFile()) {
                return;
            }
            BetterJsonObject json = new BetterJsonObject();
            json.addProperty("x", this.x);
            json.addProperty("y", this.y);
            json.addProperty("leftClick", this.leftClick);
            json.addProperty("red", this.red);
            json.addProperty("green", this.green);
            json.addProperty("blue", this.blue);
            json.addProperty("pressedRed", this.pressedRed);
            json.addProperty("pressedGreen", this.pressedGreen);
            json.addProperty("pressedBlue", this.pressedBlue);
            json.addProperty("scale", this.getScale());
            json.addProperty("fadeTime", this.getFadeTime());
            json.addProperty("enabled", this.enabled);
            json.addProperty("chroma", this.chroma);
            json.addProperty("mouseButtons", this.mouseButtons);
            json.addProperty("showCPS", this.showCPS);
            json.addProperty("showCPSOnButtons", this.showCPSOnButtons);
            json.addProperty("showSpacebar", this.showSpacebar);
            json.addProperty("showSneak", this.showingSneak);
            json.addProperty("showFPS", this.showFPS);
            json.addProperty("keyBackground", this.keyBackground);
            json.addProperty("showWASD", this.showWASD);
            json.addProperty("literalKeys", this.literalKeys);
            json.addProperty("keyBackgroundOpacity", this.keyBackgroundOpacity);
            json.addProperty("keyBackgroundRed", this.keyBackgroundRed);
            json.addProperty("keyBackgroundGreen", this.keyBackgroundGreen);
            json.addProperty("keyBackgroundBlue", this.keyBackgroundBlue);
            json.addProperty("arrowKeys", this.arrowKeys);
            JsonArray keys = new JsonArray();
            for (CustomKeyWrapper customKeyWrapper : this.keystrokes.getRenderer().getCustomKeys()) {
                JsonHolder holder = new JsonHolder();
                holder.put("key", customKeyWrapper.getKey().getKey());
                holder.put("type", customKeyWrapper.getKey().getType());
                holder.put("xOffset", customKeyWrapper.getxOffset());
                holder.put("yOffset", customKeyWrapper.getyOffset());
                keys.add((JsonElement)holder.getObject());
            }
            json.getData().add("custom", (JsonElement)keys);
            json.writeToFile(this.configFile);
        }
        catch (Exception e) {
            LogManager.getLogger((String)"Keystrokes").error("Could not save config file! {}", (Object)this.configFile.getName(), (Object)e);
        }
    }

    private void parseSettings(BetterJsonObject json) {
        this.x = json.optInt("x");
        this.y = json.optInt("y");
        this.red = json.optInt("red", 255);
        this.green = json.optInt("green", 255);
        this.blue = json.optInt("blue", 255);
        this.pressedRed = json.optInt("pressedRed");
        this.pressedGreen = json.optInt("pressedGreen");
        this.pressedBlue = json.optInt("pressedBlue");
        this.setScale(json.optDouble("scale", 1.0));
        this.setFadeTime(json.optDouble("fadeTime", 1.0));
        this.enabled = json.optBoolean("enabled", true);
        this.chroma = json.optBoolean("chroma");
        this.leftClick = json.optBoolean("leftClick", true);
        this.mouseButtons = json.optBoolean("mouseButtons");
        this.showCPS = json.optBoolean("showCPS");
        this.showCPSOnButtons = json.optBoolean("showCPSOnButtons");
        this.showSpacebar = json.optBoolean("showSpacebar");
        this.showingSneak = json.optBoolean("showSneak");
        this.showFPS = json.optBoolean("showFPS");
        this.keyBackground = json.optBoolean("keyBackground", true);
        this.showWASD = json.optBoolean("showWASD", true);
        this.literalKeys = json.optBoolean("literalKeys");
        this.keyBackgroundOpacity = json.optInt("keyBackgroundOpacity", 120);
        this.keyBackgroundRed = json.optInt("keyBackgroundRed");
        this.keyBackgroundGreen = json.optInt("keyBackgroundGreen");
        this.keyBackgroundBlue = json.optInt("keyBackgroundBlue");
        this.arrowKeys = json.optBoolean("arrowKeys");
        JsonObject data = json.getData();
        if (data.has("custom")) {
            JsonArray custom = data.getAsJsonArray("custom");
            for (JsonElement element : custom) {
                JsonHolder holder = new JsonHolder(element.getAsJsonObject());
                CustomKeyWrapper wrapper = new CustomKeyWrapper(new CustomKey(this.keystrokes, holder.optInt("key"), holder.optInt("type")), holder.optInt("xOffset"), holder.optInt("yOffset"));
                this.customKeyWrappers.add(wrapper);
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public boolean isLeftClick() {
        return this.leftClick;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isChroma() {
        return this.chroma;
    }

    public boolean isMouseButtons() {
        return this.mouseButtons;
    }

    public boolean isShowCPS() {
        return this.showCPS;
    }

    public boolean isShowCPSOnButtons() {
        return this.showCPSOnButtons;
    }

    public boolean isShowSpacebar() {
        return this.showSpacebar;
    }

    public double getScale() {
        return this.capDouble(this.scale, 0.5, 1.5);
    }

    public double getFadeTime() {
        return this.capDouble(this.fadeTime, 0.1f, 3.0);
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getPressedRed() {
        return this.pressedRed;
    }

    public int getPressedGreen() {
        return this.pressedGreen;
    }

    public int getPressedBlue() {
        return this.pressedBlue;
    }

    public boolean isShowingSneak() {
        return this.showingSneak;
    }

    public boolean isShowingFPS() {
        return this.showFPS;
    }

    public boolean isKeyBackground() {
        return this.keyBackground;
    }

    public List<CustomKeyWrapper> getCustomKeyWrappers() {
        return this.customKeyWrappers;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setChroma(boolean chroma) {
        this.chroma = chroma;
    }

    public void setMouseButtons(boolean mouseButtons) {
        this.mouseButtons = mouseButtons;
    }

    public void setShowCPS(boolean showCPS) {
        this.showCPS = showCPS;
    }

    public void setShowCPSOnButtons(boolean showCPSOnButtons) {
        this.showCPSOnButtons = showCPSOnButtons;
    }

    public void setShowSpacebar(boolean showSpacebar) {
        this.showSpacebar = showSpacebar;
    }

    public void setScale(double scale) {
        this.scale = this.capDouble(scale, 0.5, 1.5);
    }

    public void setFadeTime(double fadeTime) {
        this.fadeTime = this.capDouble(fadeTime, 0.1f, 3.0);
    }

    public void setRed(int red) {
        this.red = red;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public void setPressedRed(int pressedRed) {
        this.pressedRed = pressedRed;
    }

    public void setPressedGreen(int pressedGreen) {
        this.pressedGreen = pressedGreen;
    }

    public void setPressedBlue(int pressedBlue) {
        this.pressedBlue = pressedBlue;
    }

    public void setLeftClick(boolean leftClick) {
        this.leftClick = leftClick;
    }

    public void setShowingSneak(boolean showingSneak) {
        this.showingSneak = showingSneak;
    }

    public void setShowingFPS(boolean showFPS) {
        this.showFPS = showFPS;
    }

    public void setKeyBackground(boolean keyBackground) {
        this.keyBackground = keyBackground;
    }

    public boolean isShowingWASD() {
        return this.showWASD;
    }

    public void setShowingWASD(boolean showWASD) {
        this.showWASD = showWASD;
    }

    public boolean isUsingLiteralKeys() {
        return this.literalKeys;
    }

    public void setUsingLiteralKeys(boolean literalKeys) {
        this.literalKeys = literalKeys;
    }

    public int getKeyBackgroundOpacity() {
        return this.keyBackgroundOpacity;
    }

    public void setKeyBackgroundOpacity(int keyBackgroundOpacity) {
        this.keyBackgroundOpacity = keyBackgroundOpacity;
    }

    public int getKeyBackgroundRed() {
        return this.keyBackgroundRed;
    }

    public void setKeyBackgroundRed(int keyBackgroundRed) {
        this.keyBackgroundRed = keyBackgroundRed;
    }

    public int getKeyBackgroundGreen() {
        return this.keyBackgroundGreen;
    }

    public void setKeyBackgroundGreen(int keyBackgroundGreen) {
        this.keyBackgroundGreen = keyBackgroundGreen;
    }

    public int getKeyBackgroundBlue() {
        return this.keyBackgroundBlue;
    }

    public void setKeyBackgroundBlue(int keyBackgroundBlue) {
        this.keyBackgroundBlue = keyBackgroundBlue;
    }

    public boolean isUsingArrowKeys() {
        return this.arrowKeys;
    }

    public void setUsingArrowKeys(boolean arrowKeys) {
        this.arrowKeys = arrowKeys;
    }

    public int getHeight() {
        int height = 50;
        if (this.showCPS || this.showSpacebar || this.showFPS) {
            height += 24;
        }
        if (this.mouseButtons) {
            height += 24;
        }
        if (this.showWASD) {
            height += 48;
        }
        if (!this.showFPS) {
            height -= 18;
        }
        if (!this.showCPS) {
            height -= 18;
        }
        if (this.showCPSOnButtons) {
            height -= 18;
        }
        return height;
    }

    public int getWidth() {
        return 74;
    }

    private double capDouble(double valueIn, double minValue, double maxValue) {
        return valueIn < minValue ? minValue : Math.min(valueIn, maxValue);
    }

    public int getRenderX() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int width = this.getWidth();
        int x = this.getX();
        if (x < 0) {
            x = 0;
        } else if ((double)x * this.getScale() > (double)res.func_78326_a() - (double)width * this.getScale()) {
            x = (int)(((double)res.func_78326_a() - (double)width * this.getScale()) / this.getScale());
        }
        return x;
    }

    public int getRenderY() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x());
        int height = this.getHeight();
        int y = this.getY();
        if (y < 0) {
            y = 0;
        } else if ((double)y * this.getScale() > (double)res.func_78328_b() - (double)height * this.getScale()) {
            y = (int)(((double)res.func_78328_b() - (double)height * this.getScale()) / this.getScale());
        }
        return y;
    }
}

