/*
 * Decompiled with CFR 0.152.
 */
package nukeduck.armorchroma;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nukeduck.armorchroma.GuiArmor;
import nukeduck.armorchroma.config.IconData;
import org.apache.logging.log4j.Logger;

@Mod(modid="armorchroma", name="Armor Chroma", version="1.4-beta", acceptedMinecraftVersions="[1.11,1.13)")
public class ArmorChroma {
    public static final Minecraft MINECRAFT = Minecraft.func_71410_x();
    public static final String MODID = "armorchroma";
    private static final GuiArmor GUI = new GuiArmor();
    private static final IconData ICON_DATA = new IconData();
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
    }

    public static IconData getIconData() {
        return ICON_DATA;
    }

    public static Logger getLogger() {
        return logger;
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)manager).func_110542_a(ICON_DATA::reload);
        } else {
            logger.error("Unable to register icon loader");
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGameOverlayEvent.Pre e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.ARMOR) {
            e.setCanceled(true);
            GUI.draw(e.getResolution().func_78326_a(), e.getResolution().func_78328_b());
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent e) {
        if (e.getFlags().func_194127_a() && e.getItemStack().func_77973_b() instanceof ItemArmor) {
            String material = ((ItemArmor)e.getItemStack().func_77973_b()).func_82812_d().func_179242_c();
            e.getToolTip().add(TextFormatting.DARK_GRAY + "Armor Material: " + material);
        }
    }
}

