/*
 * Decompiled with CFR 0.152.
 */
package nukeduck.armorchroma;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.common.ISpecialArmor;
import nukeduck.armorchroma.ArmorChroma;
import nukeduck.armorchroma.config.ArmorChromaConfig;
import nukeduck.armorchroma.config.ArmorIcon;
import nukeduck.armorchroma.config.Util;
import org.lwjgl.opengl.GL11;

public class GuiArmor
extends Gui {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("armorchroma", "textures/gui/background.png");
    private static final ResourceLocation GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final int GLINT_COLOR = 6369435;
    private static final int[] BG_COLORS = new int[]{3853055, 3925338, 0xFFFF00, 16751872, 15544832, 7418049};
    private static final int ROW_SPACING = 5;
    private static final int GL_GLINT_BITS = 28929;

    public void draw(int width, int height) {
        ArmorChroma.MINECRAFT.field_71424_I.func_76320_a("armor");
        int left = width / 2 - 91;
        int top = height - GuiIngameForge.left_height;
        GL11.glEnable((int)3042);
        int barPoints = 0;
        LinkedHashMap<EntityEquipmentSlot, Integer> pointsMap = new LinkedHashMap<EntityEquipmentSlot, Integer>();
        int totalPoints = this.getArmorPoints((EntityPlayer)ArmorChroma.MINECRAFT.field_71439_g, pointsMap);
        int compressedRows = ArmorChromaConfig.compressBar ? this.compressRows(pointsMap, totalPoints) : 0;
        this.field_73735_i = -2.0f;
        for (Map.Entry entry : pointsMap.entrySet()) {
            this.drawPiece(left, top, barPoints, (Integer)entry.getValue(), ArmorChroma.MINECRAFT.field_71439_g.func_184582_a((EntityEquipmentSlot)entry.getKey()));
            barPoints += ((Integer)entry.getValue()).intValue();
        }
        this.drawBackground(left, top, compressedRows);
        GuiIngameForge.left_height += (barPoints - 1) / 20 * 5 + 10;
        ArmorChroma.MINECRAFT.func_110434_K().func_110577_a(field_110324_m);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        ArmorChroma.MINECRAFT.field_71424_I.func_76319_b();
    }

    private void drawBackground(int x, int y, int level) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUND);
        this.func_73729_b(x, y, 0, 0, 81, 9);
        if (level > 0) {
            int color = level <= BG_COLORS.length ? BG_COLORS[level - 1] : BG_COLORS[BG_COLORS.length - 1];
            Util.setColor(color);
            this.func_73729_b(x - 1, y - 1, 81, 0, 83, 11);
        }
    }

    private void drawPiece(int left, int top, int barPoints, int stackPoints, ItemStack stack) {
        int space;
        top -= barPoints / 20 * 5;
        while ((space = 20 - barPoints % 20) <= stackPoints) {
            this.drawPartialRow(left, top, 20 - space, space, stack);
            this.field_73735_i -= 3.0f;
            top -= 5;
            barPoints += space;
            stackPoints -= space;
        }
        if (stackPoints > 0) {
            this.drawPartialRow(left, top, 20 - space, stackPoints, stack);
            this.field_73735_i -= 1.0f;
        }
    }

    private void drawPartialRow(int left, int top, int barPoints, int stackPoints, ItemStack stack) {
        boolean glint;
        ArmorIcon icon = ArmorChroma.getIconData().getIcon(stack);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon.texture);
        boolean bl = glint = ArmorChromaConfig.renderGlint && stack.func_77962_s();
        if (glint) {
            this.field_73735_i += 2.0f;
        }
        int i = barPoints & 1;
        int x = left + barPoints * 4;
        if (i == 1) {
            this.drawMaskedIcon(x - 4, top, icon, ArmorChroma.getIconData().getSpecial(Util.getModid(stack), "leadingMask"));
            x += 4;
        }
        while (i < stackPoints - 1) {
            icon.draw(this, x, top);
            i += 2;
            x += 8;
        }
        if (i < stackPoints) {
            this.drawMaskedIcon(x, top, icon, ArmorChroma.getIconData().getSpecial(Util.getModid(stack), "trailingMask"));
        }
        if (glint) {
            this.drawTexturedGlintRect(left + barPoints * 4, top, left, 0, stackPoints * 4 + 1, 9);
            this.field_73735_i -= 2.0f;
        }
    }

    private int getArmorPoints(EntityPlayer player, Map<EntityEquipmentSlot, Integer> pointsMap) {
        AttributeMap attributes = new AttributeMap();
        IAttributeInstance armor = attributes.func_111150_b(SharedMonsterAttributes.field_188791_g);
        int attrLast = (int)armor.func_111126_e();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = player.func_184582_a(slot);
            attributes.func_111147_b(stack.func_111283_C(slot));
            int attrNext = (int)armor.func_111126_e();
            int points = attrNext - attrLast;
            attrLast = attrNext;
            if (slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR && stack.func_77973_b() instanceof ISpecialArmor) {
                points += ((ISpecialArmor)stack.func_77973_b()).getArmorDisplay(player, stack, slot.func_188454_b());
            }
            if (points <= 0) continue;
            pointsMap.put(slot, points);
        }
        return attrLast;
    }

    private int compressRows(Map<EntityEquipmentSlot, Integer> pointsMap, int totalPoints) {
        int d;
        int compressedRows = (totalPoints - 1) / 20;
        int compressedPoints = compressedRows * 20;
        Iterator<Map.Entry<EntityEquipmentSlot, Integer>> it = pointsMap.entrySet().iterator();
        for (int i = 0; i < compressedPoints; i += d) {
            Map.Entry<EntityEquipmentSlot, Integer> entry = it.next();
            d = Math.min(compressedPoints - i, entry.getValue());
            if (d == entry.getValue()) {
                it.remove();
                continue;
            }
            entry.setValue(entry.getValue() - d);
        }
        return compressedRows;
    }

    public void drawMaskedIcon(int x, int y, ArmorIcon icon, ArmorIcon mask) {
        mask.draw(this, x, y);
        GL11.glDepthFunc((int)514);
        GL11.glBlendFunc((int)774, (int)0);
        icon.draw(this, x, y);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthFunc((int)515);
    }

    public void drawTexturedGlintRect(int x, int y, int u, int v, int width, int height) {
        GL11.glPushAttrib((int)28929);
        GL11.glDepthFunc((int)514);
        OpenGlHelper.func_148821_a((int)768, (int)1, (int)1, (int)0);
        ArmorChroma.MINECRAFT.func_110434_K().func_110577_a(GLINT);
        GL11.glMatrixMode((int)5890);
        long time = Minecraft.func_71386_F();
        Util.setColor(6369435);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        GL11.glTranslatef((float)((float)(time % 3000L) / 3000.0f * 8.0f), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x, y, u, v, width, height);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.125f, (float)0.125f, (float)0.125f);
        GL11.glTranslatef((float)((float)(time % 4873L) / 4873.0f * -8.0f), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(x, y, u, v, width, height);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

