/*
 * Decompiled with CFR 0.152.
 */
package nukeduck.armorchroma.config;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import nukeduck.armorchroma.ArmorChroma;
import nukeduck.armorchroma.config.ArmorIcon;
import nukeduck.armorchroma.config.IconTable;
import nukeduck.armorchroma.config.Util;

public class IconData {
    private final Map<String, IconTable> mods = new HashMap<String, IconTable>();
    private static final ArmorIcon FALLBACK_ICON = new ArmorIcon(0);
    public static final String DEFAULT = "default";
    public static final String MINECRAFT = "minecraft";

    public void reload(IResourceManager manager) {
        this.mods.clear();
        for (String modid : Loader.instance().getIndexedModList().keySet()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(modid, "textures/gui/armor_chroma.json"))) {
                    try {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(resource.func_110527_b()));
                        Throwable throwable = null;
                        try {
                            IconTable mod = (IconTable)new Gson().fromJson((Reader)reader, IconTable.class);
                            this.mods.merge(modid, mod, (a, b) -> {
                                a.putAll((IconTable)b);
                                return a;
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (JsonIOException | JsonSyntaxException | IOException e) {
                        ArmorChroma.getLogger().error("Loading modid {}", (Object)modid, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                if (MINECRAFT.equals(modid)) {
                    throw new RuntimeException("Missing fallback icons. The mod is damaged", e);
                }
                if (e instanceof FileNotFoundException) continue;
                ArmorChroma.getLogger().error("Loading modid {}", (Object)modid, (Object)e);
            }
        }
        IconTable minecraft = this.mods.get(MINECRAFT);
        if (minecraft == null || minecraft.getSpecialIndex(DEFAULT) == null || minecraft.getSpecialIndex("leadingMask") == null || minecraft.getSpecialIndex("trailingMask") == null) {
            throw new RuntimeException("Missing fallback icons. The mod is damaged");
        }
        ArmorChroma.getLogger().info("Loaded {} mods", (Object)(this.mods.size() - 1));
    }

    public ArmorIcon getIcon(ItemStack stack) {
        String modid = Util.getModid(stack);
        IconTable mod = this.mods.get(modid);
        Integer i = null;
        if (mod != null) {
            i = mod.getIconIndex(stack);
            if (i != null) {
                return new ArmorIcon(modid, i, Util.getColor(stack));
            }
            return this.getSpecial(modid, DEFAULT);
        }
        return this.getSpecial(MINECRAFT, DEFAULT);
    }

    public ArmorIcon getSpecial(String modid, String key) {
        IconTable mod = this.mods.get(modid);
        if (mod == null && (mod = this.mods.get(modid = MINECRAFT)) == null) {
            return FALLBACK_ICON;
        }
        Integer i = mod.getSpecialIndex(key);
        return i != null ? new ArmorIcon(modid, (int)i) : this.getSpecial(MINECRAFT, key);
    }
}

