/*
 * Decompiled with CFR 0.152.
 */
package schmille.bamboo2.common;

import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final Composter COMPOSTER = new Composter(BUILDER);
    public static final RawBamboo RAW_BAMBOO = new RawBamboo(BUILDER);
    public static final CookedBamboo COOKED_BAMBOO = new CookedBamboo(BUILDER);
    public static ForgeConfigSpec SPEC = BUILDER.build();

    public static class CookedBamboo {
        public final ForgeConfigSpec.ConfigValue<Boolean> cookable;
        public final ForgeConfigSpec.ConfigValue<Integer> hunger_value;
        public final ForgeConfigSpec.ConfigValue<Double> saturation_value;

        public CookedBamboo(ForgeConfigSpec.Builder builder) {
            builder.push("Cooked Bamboo");
            this.cookable = builder.comment("If false, you will not be able to optain cooked bamboo through smelting").define("cookable", true);
            this.hunger_value = builder.comment("How much hunger will be restored when eaten.").define("cooked_hunger_value", (Object)4);
            this.saturation_value = builder.comment("Modifier for how fast the hungerbar will deplete (lower means faster)").define("cooked_saturation_value", (Object)0.5);
            builder.pop();
        }
    }

    public static class RawBamboo {
        public final ForgeConfigSpec.ConfigValue<Boolean> edible;
        public final ForgeConfigSpec.ConfigValue<Integer> hunger_value;
        public final ForgeConfigSpec.ConfigValue<Double> saturation_value;
        public final ForgeConfigSpec.ConfigValue<Boolean> apply_slowness;
        public final ForgeConfigSpec.ConfigValue<Integer> slowness_duration;
        public final ForgeConfigSpec.ConfigValue<Integer> slowness_level;
        public final ForgeConfigSpec.ConfigValue<Double> effect_chance;

        public RawBamboo(ForgeConfigSpec.Builder builder) {
            builder.push("Raw Bamboo");
            this.edible = builder.comment("If true, bamboo can be eaten.").define("can_eat_raw", true);
            this.hunger_value = builder.comment("How much hunger will be restored when eaten.").define("raw_hunger_value", (Object)2);
            this.saturation_value = builder.comment("Modifier for how fast the hungerbar will deplete (lower means faster)").define("raw_saturation_value", (Object)0.3);
            builder.pop();
            builder.push("Raw Bamboo slowness");
            this.apply_slowness = builder.comment("If true, eating raw bamboo will apply slowness").define("raw_apply_slowness", true);
            this.slowness_duration = builder.comment("Duration of the slowness effect (in seconds)").define("raw_slowness_duration", (Object)5);
            this.slowness_level = builder.comment("Slowness level").define("raw_slowness_level", (Object)1);
            this.effect_chance = builder.comment("Chance that the slowness effect is triggered").define("raw_slowness_chance", (Object)1.0);
            builder.pop();
        }
    }

    public static class Composter {
        public final ForgeConfigSpec.ConfigValue<Boolean> can_decompose;
        public final ForgeConfigSpec.ConfigValue<Double> compost_chance;

        public Composter(ForgeConfigSpec.Builder builder) {
            builder.push("Composter");
            this.can_decompose = builder.comment("If true, bamboo can be composted").define("can_decompose", true);
            this.compost_chance = builder.comment("Sets the chance for Bamboo to partly fill a composter. The higher the value, the less Bamboo is needed to fill a composter.\n(Leaves = 0.3, Sugar Cane = 0.5, Wheat = 0.65, Bread = 0.85, Cake = 1.0)").define("compose_chance", (Object)0.3);
            builder.pop();
        }
    }
}

