/*
 * Decompiled with CFR 0.152.
 */
package org.featurehouse.mcmod.brightore;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3264;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.featurehouse.mcmod.brightore.OreTagLoader;

@Environment(value=EnvType.CLIENT)
public enum BrightOreConfig {
    INSTANCE;

    private static final File CONFIG_FILE;
    private static final Gson GSON;
    private static final Logger LOGGER;
    private boolean render;

    public static void onInitialize() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new OreTagLoader());
        INSTANCE.reload();
    }

    public boolean render() {
        return this.render;
    }

    public void setRender(boolean render) {
        this.render = render;
    }

    public void save() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(CONFIG_FILE));
            String s = GSON.toJson((JsonElement)this.toJson());
            bw.write(s);
            bw.close();
        }
        catch (IOException e) {
            LOGGER.fatal("Cannot save", (Throwable)e);
        }
    }

    public void reload() {
        if (!CONFIG_FILE.exists()) {
            LOGGER.info("Creating config file: {}", (Object)CONFIG_FILE.getAbsolutePath());
            try {
                CONFIG_FILE.getParentFile().mkdirs();
                CONFIG_FILE.createNewFile();
                BufferedWriter bw = new BufferedWriter(new FileWriter(CONFIG_FILE));
                bw.write("{\n  \"render\": true\n}");
                bw.close();
            }
            catch (IOException e) {
                LOGGER.fatal("Cannot load config", (Throwable)e);
            }
            finally {
                LOGGER.info("Setting up default values");
                this.setToDefault();
            }
        } else {
            try {
                BufferedReader br = new BufferedReader(new FileReader(CONFIG_FILE));
                JsonElement je = new JsonParser().parse((Reader)br);
                JsonObject root = class_3518.method_15295((JsonElement)je, (String)"root");
                this.fromJson(root);
                br.close();
            }
            catch (JsonParseException | IOException e) {
                LOGGER.fatal("Cannot load config", e);
                this.setToDefault();
            }
        }
    }

    protected void setToDefault() {
        this.render = true;
    }

    protected JsonObject toJson() {
        JsonObject root = new JsonObject();
        root.add("render", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.render)));
        return root;
    }

    protected void fromJson(JsonObject root) throws JsonSyntaxException {
        this.render = class_3518.method_15270((JsonObject)root, (String)"render");
    }

    static {
        GSON = new Gson();
        LOGGER = LogManager.getLogger((String)"Bright Ore Config");
        CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("org.featurehouse.mcmod.bright-ore/config.json").toFile();
    }
}

