/*
 * Decompiled with CFR 0.152.
 */
package org.featurehouse.mcmod.brightore;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2431;
import net.minecraft.class_2449;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.featurehouse.mcmod.brightore.BrightOreConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class OreTagLoader
extends class_4309
implements IdentifiableResourceReloadListener {
    protected static final class_2960 FABRIC_ID = new class_2960("bright_ore", "ore_tags");
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger LOGGER = LogManager.getLogger((String)"Ore Tag Loader");

    public OreTagLoader() {
        super(GSON, "ore_tags");
    }

    public class_2960 getFabricId() {
        return FABRIC_ID;
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        prepared.forEach((fileId, json) -> {
            JsonArray root = class_3518.method_15252((JsonElement)json, (String)fileId.toString());
            for (JsonElement je : root) {
                if (je.isJsonObject()) {
                    JsonObject obj = je.getAsJsonObject();
                    try {
                        @Nullable JsonElement je2 = obj.get("light");
                        int light = je2 == null ? 30 : je2.getAsInt();
                        String string = obj.get("value").getAsString();
                        OreTagLoader.put(string, light);
                        continue;
                    }
                    catch (RuntimeException e) {
                        if (!obj.get("required").getAsBoolean()) {
                            LOGGER.debug("Ignored error", (Throwable)e);
                            continue;
                        }
                        throw e;
                    }
                }
                String string = je.getAsString();
                OreTagLoader.put(string, 30);
            }
        });
    }

    private static void put(String string, int light) throws RuntimeException {
        if (string.startsWith("#")) {
            class_2960 tagId = new class_2960(string.substring(1));
            class_3494 tag = class_3481.method_15073().method_30210(tagId);
            if (tag == null) {
                throw new NullPointerException("Invalid tag: " + string);
            }
            for (class_2248 block : tag.method_15138()) {
                if (!OreTagLoader.notAir(block)) continue;
                OreTagMap.INSTANCE.put(block, light);
            }
        } else {
            class_2960 blockId = new class_2960(string);
            @NotNull class_2248 block = (class_2248)class_2378.field_11146.method_10223(blockId);
            if (OreTagLoader.notAir(block)) {
                OreTagMap.INSTANCE.put(block, light);
            }
        }
    }

    private static boolean notAir(class_2248 block) {
        return block != class_2246.field_10124 && block != class_2246.field_10543 && block != class_2246.field_10243;
    }

    public static int redirectLuminance(class_2680 it) {
        if (BrightOreConfig.INSTANCE.render()) {
            class_2248 block1 = it.method_26204();
            if (OreTagMap.INSTANCE.containsKey(block1)) {
                return OreTagMap.INSTANCE.getValue(block1);
            }
            if (block1 instanceof class_2431 || block1 instanceof class_2449) {
                return 30;
            }
        }
        return it.method_26213();
    }

    public static enum OreTagMap {
        INSTANCE;

        private final Object2IntMap<class_2248> map = new Object2IntOpenHashMap();

        public Object2IntMap<class_2248> get() {
            return this.map;
        }

        public boolean containsKey(class_2248 block) {
            return this.map.containsKey((Object)block);
        }

        public int getValue(class_2248 block) {
            return this.map.getOrDefault((Object)block, 0);
        }

        public int put(class_2248 block, int light) {
            return this.map.put((Object)block, light);
        }

        public int put(class_2248 block) {
            return this.put(block, 30);
        }

        public boolean available(class_2248 block) {
            if (!this.map.containsKey((Object)block)) {
                return false;
            }
            return this.getValue(block) > 0;
        }

        public void forEach(BiConsumer<class_2248, Integer> consumer) {
            this.map.forEach(consumer);
        }
    }
}

