/*
 * Decompiled with CFR 0.152.
 */
package org.featurehouse.mcmod.brightore.mixin.compat;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BrightOreMixinConfig
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LogManager.getLogger((String)"Bright Ore Mixin Config");
    private Set<String> incompatibleMixins = new HashSet<String>();
    private boolean loaded = false;

    public void onLoad(String mixinPackage) {
        LOGGER.info("Loading Mixin Config at {}", (Object)mixinPackage);
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        LOGGER.info("Checking mod custom values");
        block4: for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = modContainer.getMetadata();
            if (!meta.containsCustomValue("bright-ore:incompatible-mixins")) continue;
            CustomValue cv = meta.getCustomValue("bright-ore:incompatible-mixins");
            switch (cv.getType()) {
                case STRING: {
                    if (cv.getAsString().equals("*")) {
                        this.incompatibleMixins = null;
                        break block4;
                    }
                    this.incompatibleMixins.add(cv.getAsString());
                    break;
                }
                case ARRAY: {
                    cv.getAsArray().forEach(each -> this.incompatibleMixins.add(each.getAsString()));
                    break;
                }
                default: {
                    LOGGER.warn("Invalid Class Name: {}. Skipped.", (Object)cv.getAsString());
                }
            }
        }
        this.loaded = true;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        this.load();
        if (this.incompatibleMixins == null) {
            return false;
        }
        return !this.incompatibleMixins.contains(mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    @Nullable
    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

