/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseBlock;
import com.mrh0.buildersaddition.tileentity.ArcadeTileEntity;
import com.mrh0.buildersaddition.tileentity.CounterTileEntity;
import com.mrh0.buildersaddition.util.Util;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class Arcade
extends BaseBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static VoxelShape SHAPE_NORTH_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_LOWER = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_LOWER = Block.func_208617_a((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0);
    private static VoxelShape SHAPE_NORTH_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_EAST_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0);
    private static VoxelShape SHAPE_SOUTH_UPPER = Block.func_208617_a((double)0.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static VoxelShape SHAPE_WEST_UPPER = Block.func_208617_a((double)1.0, (double)-16.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public Arcade() {
        super("arcade", AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150339_S).func_226896_b_().func_235827_a_((state, reader, pos, entity) -> false).func_235828_a_(Util::isntSolid).func_235842_b_(Util::isntSolid).func_235847_c_(Util::isntSolid));
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.BLOCK;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof CounterTileEntity) {
            ((CounterTileEntity)tileentity).func_213903_a(stack.func_200301_q());
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? true : blockstate.func_203425_a((Block)this);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HALF});
    }

    private VoxelShape getShapeForDirection(Direction d, boolean b) {
        switch (d) {
            case NORTH: {
                return b ? SHAPE_NORTH_UPPER : SHAPE_NORTH_LOWER;
            }
            case SOUTH: {
                return b ? SHAPE_SOUTH_UPPER : SHAPE_SOUTH_LOWER;
            }
            case EAST: {
                return b ? SHAPE_EAST_UPPER : SHAPE_EAST_LOWER;
            }
            case WEST: {
                return b ? SHAPE_WEST_UPPER : SHAPE_WEST_LOWER;
            }
        }
        return SHAPE_NORTH_LOWER;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.getShapeForDirection((Direction)state.func_177229_b((Property)FACING), state.func_177229_b(HALF) == DoubleBlockHalf.UPPER);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_175149_v()) {
            return ActionResultType.PASS;
        }
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ArcadeTileEntity mte = this.getTE(state, worldIn, pos);
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)mte, extraData -> extraData.func_179255_a(mte.func_174877_v()));
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            ArcadeTileEntity tileentity = this.getTE(state, worldIn, pos);
            if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
                worldIn.func_175656_a(pos.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            } else {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private ArcadeTileEntity getTE(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileentity = state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? worldIn.func_175625_s(pos) : worldIn.func_175625_s(pos.func_177977_b());
        if (tileentity != null && tileentity instanceof ArcadeTileEntity) {
            return (ArcadeTileEntity)tileentity;
        }
        return null;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_189539_a(BlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ArcadeTileEntity();
    }
}

