/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.state.MountState;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;

public class SupportBracket
extends BaseDerivativeBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final DirectionProperty SUPPORTING = DirectionProperty.func_177712_a((String)"supporting", p -> p == Direction.UP || p == Direction.DOWN);
    public static final EnumProperty<MountState> MOUNT = EnumProperty.func_177709_a((String)"mount", MountState.class);
    protected static final VoxelShape SHAPE_UP_SOUTH = Block.func_208617_a((double)6.0, (double)4.0, (double)4.0, (double)10.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP_NORTH = Block.func_208617_a((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)16.0, (double)12.0);
    protected static final VoxelShape SHAPE_UP_EAST = Block.func_208617_a((double)4.0, (double)4.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST = Block.func_208617_a((double)0.0, (double)4.0, (double)6.0, (double)12.0, (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH = Block.func_208617_a((double)6.0, (double)0.0, (double)4.0, (double)10.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN_NORTH = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)12.0, (double)12.0);
    protected static final VoxelShape SHAPE_DOWN_EAST = Block.func_208617_a((double)4.0, (double)0.0, (double)6.0, (double)16.0, (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)12.0, (double)12.0, (double)10.0);
    static int o1 = 2;
    protected static final VoxelShape SHAPE_UP_SOUTH_PILLAR = Block.func_208617_a((double)6.0, (double)4.0, (double)(4.0 + (double)o1), (double)10.0, (double)16.0, (double)(16.0 + (double)o1));
    protected static final VoxelShape SHAPE_UP_NORTH_PILLAR = Block.func_208617_a((double)6.0, (double)4.0, (double)(0.0 - (double)o1), (double)10.0, (double)16.0, (double)(12.0 - (double)o1));
    protected static final VoxelShape SHAPE_UP_EAST_PILLAR = Block.func_208617_a((double)(4.0 + (double)o1), (double)4.0, (double)6.0, (double)(16.0 + (double)o1), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_PILLAR = Block.func_208617_a((double)(0.0 - (double)o1), (double)4.0, (double)6.0, (double)(12.0 - (double)o1), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_PILLAR = Block.func_208617_a((double)6.0, (double)0.0, (double)(4.0 + (double)o1), (double)10.0, (double)12.0, (double)(16.0 + (double)o1));
    protected static final VoxelShape SHAPE_DOWN_NORTH_PILLAR = Block.func_208617_a((double)6.0, (double)0.0, (double)(0.0 - (double)o1), (double)10.0, (double)12.0, (double)(12.0 - (double)o1));
    protected static final VoxelShape SHAPE_DOWN_EAST_PILLAR = Block.func_208617_a((double)(4.0 + (double)o1), (double)0.0, (double)6.0, (double)(16.0 + (double)o1), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_PILLAR = Block.func_208617_a((double)(0.0 - (double)o1), (double)0.0, (double)6.0, (double)(12.0 - (double)o1), (double)12.0, (double)10.0);
    static int o2 = 4;
    protected static final VoxelShape SHAPE_UP_SOUTH_WALL = Block.func_208617_a((double)6.0, (double)4.0, (double)(4.0 + (double)o2 - 2.0), (double)10.0, (double)16.0, (double)(16.0 + (double)o2));
    protected static final VoxelShape SHAPE_UP_NORTH_WALL = Block.func_208617_a((double)6.0, (double)4.0, (double)(0.0 - (double)o2), (double)10.0, (double)16.0, (double)(12.0 - (double)o2 + 2.0));
    protected static final VoxelShape SHAPE_UP_EAST_WALL = Block.func_208617_a((double)(4.0 + (double)o2 - 2.0), (double)4.0, (double)6.0, (double)(16.0 + (double)o2), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_WALL = Block.func_208617_a((double)(0.0 - (double)o2), (double)4.0, (double)6.0, (double)(12.0 - (double)o2 + 2.0), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_WALL = Block.func_208617_a((double)6.0, (double)0.0, (double)(4.0 + (double)o2 - 2.0), (double)10.0, (double)12.0, (double)(16.0 + (double)o2));
    protected static final VoxelShape SHAPE_DOWN_NORTH_WALL = Block.func_208617_a((double)6.0, (double)0.0, (double)(0.0 - (double)o2), (double)10.0, (double)12.0, (double)(12.0 - (double)o2 + 2.0));
    protected static final VoxelShape SHAPE_DOWN_EAST_WALL = Block.func_208617_a((double)(4.0 + (double)o2 - 2.0), (double)0.0, (double)6.0, (double)(16.0 + (double)o2), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_WALL = Block.func_208617_a((double)(0.0 - (double)o2), (double)0.0, (double)6.0, (double)(12.0 - (double)o2 + 2.0), (double)12.0, (double)10.0);
    static int o3 = 6;
    protected static final VoxelShape SHAPE_UP_SOUTH_FENCE = Block.func_208617_a((double)6.0, (double)4.0, (double)(4.0 + (double)o3 - 4.0), (double)10.0, (double)16.0, (double)(16.0 + (double)o3));
    protected static final VoxelShape SHAPE_UP_NORTH_FENCE = Block.func_208617_a((double)6.0, (double)4.0, (double)(0.0 - (double)o3), (double)10.0, (double)16.0, (double)(12.0 - (double)o3 + 4.0));
    protected static final VoxelShape SHAPE_UP_EAST_FENCE = Block.func_208617_a((double)(4.0 + (double)o3 - 4.0), (double)4.0, (double)6.0, (double)(16.0 + (double)o3), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_UP_WEST_FENCE = Block.func_208617_a((double)(0.0 - (double)o3), (double)4.0, (double)6.0, (double)(12.0 - (double)o3 + 4.0), (double)16.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_SOUTH_FENCE = Block.func_208617_a((double)6.0, (double)0.0, (double)(4.0 + (double)o3 - 4.0), (double)10.0, (double)12.0, (double)(16.0 + (double)o3));
    protected static final VoxelShape SHAPE_DOWN_NORTH_FENCE = Block.func_208617_a((double)6.0, (double)0.0, (double)(0.0 - (double)o3), (double)10.0, (double)12.0, (double)(12.0 - (double)o3 + 4.0));
    protected static final VoxelShape SHAPE_DOWN_EAST_FENCE = Block.func_208617_a((double)(4.0 + (double)o3 - 4.0), (double)0.0, (double)6.0, (double)(16.0 + (double)o3), (double)12.0, (double)10.0);
    protected static final VoxelShape SHAPE_DOWN_WEST_FENCE = Block.func_208617_a((double)(0.0 - (double)o3), (double)0.0, (double)6.0, (double)(12.0 - (double)o3 + 4.0), (double)12.0, (double)10.0);

    public SupportBracket(String name) {
        super("support_bracket_" + name, Blocks.field_196662_n);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SUPPORTING, (Comparable)Direction.UP)).func_206870_a(MOUNT, (Comparable)((Object)MountState.FullBlock)));
    }

    public SupportBracket(String name, Block b) {
        super("support_bracket_" + name, b);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)SUPPORTING, (Comparable)Direction.UP)).func_206870_a(MOUNT, (Comparable)((Object)MountState.FullBlock)));
    }

    private VoxelShape getShapeNorth(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_NORTH : SHAPE_DOWN_NORTH;
            }
            case Pillar: {
                return up ? SHAPE_UP_NORTH_PILLAR : SHAPE_DOWN_NORTH_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_NORTH_WALL : SHAPE_DOWN_NORTH_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_NORTH_FENCE : SHAPE_DOWN_NORTH_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeSouth(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_SOUTH : SHAPE_DOWN_SOUTH;
            }
            case Pillar: {
                return up ? SHAPE_UP_SOUTH_PILLAR : SHAPE_DOWN_SOUTH_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_SOUTH_WALL : SHAPE_DOWN_SOUTH_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_SOUTH_FENCE : SHAPE_DOWN_SOUTH_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeEast(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_EAST : SHAPE_DOWN_EAST;
            }
            case Pillar: {
                return up ? SHAPE_UP_EAST_PILLAR : SHAPE_DOWN_EAST_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_EAST_WALL : SHAPE_DOWN_EAST_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_EAST_FENCE : SHAPE_DOWN_EAST_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    private VoxelShape getShapeWest(MountState s, boolean up) {
        switch (s) {
            case FullBlock: {
                return up ? SHAPE_UP_WEST : SHAPE_DOWN_WEST;
            }
            case Pillar: {
                return up ? SHAPE_UP_WEST_PILLAR : SHAPE_DOWN_WEST_PILLAR;
            }
            case Wall: {
                return up ? SHAPE_UP_WEST_WALL : SHAPE_DOWN_WEST_WALL;
            }
            case Fence: {
                return up ? SHAPE_UP_WEST_FENCE : SHAPE_DOWN_WEST_FENCE;
            }
        }
        return SHAPE_UP_NORTH;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return this.getShapeNorth((MountState)((Object)state.func_177229_b(MOUNT)), state.func_177229_b((Property)SUPPORTING) == Direction.UP);
            }
            case EAST: {
                return this.getShapeEast((MountState)((Object)state.func_177229_b(MOUNT)), state.func_177229_b((Property)SUPPORTING) == Direction.UP);
            }
            case SOUTH: {
                return this.getShapeSouth((MountState)((Object)state.func_177229_b(MOUNT)), state.func_177229_b((Property)SUPPORTING) == Direction.UP);
            }
            case WEST: {
                return this.getShapeWest((MountState)((Object)state.func_177229_b(MOUNT)), state.func_177229_b((Property)SUPPORTING) == Direction.UP);
            }
        }
        return SHAPE_UP_NORTH;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, SUPPORTING, MOUNT});
    }

    public BlockState func_196258_a(BlockItemUseContext c) {
        Direction f = c.func_196000_l();
        if (f == Direction.UP) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_195992_f())).func_206870_a((Property)SUPPORTING, (Comparable)Direction.DOWN);
        }
        if (f == Direction.DOWN) {
            return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)c.func_195992_f())).func_206870_a((Property)SUPPORTING, (Comparable)Direction.UP);
        }
        double flag = c.func_221532_j().field_72448_b - (double)c.func_195995_a().func_177956_o() - 0.5;
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)f.func_176734_d())).func_206870_a((Property)SUPPORTING, (Comparable)(flag > 0.0 ? Direction.UP : Direction.DOWN))).func_206870_a(MOUNT, (Comparable)((Object)MountState.getFor(c.func_196000_l(), c.func_195995_a(), c.func_195991_k())));
    }
}

