/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.tileentity;

import com.mrh0.buildersaddition.Index;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.container.SpeakerContainer;
import com.mrh0.buildersaddition.network.IIntData;
import com.mrh0.buildersaddition.tileentity.base.BaseInstrument;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SpeakerTileEntity
extends BaseInstrument
implements INamedContainerProvider,
IIntData {
    private int instruments;
    public static int latestNotes = 0;

    public SpeakerTileEntity() {
        super(Index.SPEAKER_TILE_ENTITY_TYPE);
    }

    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return SpeakerContainer.create(windowId, inv, this.func_174877_v());
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.buildersaddition.speaker");
    }

    @Override
    public void playNote(int note) {
        if (!((Boolean)Config.MIDI_ENABLED.get()).booleanValue() || !((Boolean)Config.MIDI_SOUND_ENABLED.get()).booleanValue()) {
            return;
        }
        if (note > 0 && note <= 24) {
            if (this.isInstrumentActive(0)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_187679_dF, note);
            }
            if (this.isInstrumentActive(1)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_187688_dI, note);
            }
            if (this.isInstrumentActive(2)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_187685_dH, note);
            }
            if (this.isInstrumentActive(3)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_187676_dE, note);
            }
            if (this.isInstrumentActive(11)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_219663_hb, note);
            }
        }
        if (note > 12 && note <= 36 && this.isInstrumentActive(7)) {
            SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_193810_ez, note - 12);
        }
        if (note > 24 && note <= 48) {
            if (this.isInstrumentActive(6)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_193808_ex, note - 24);
            }
            if (this.isInstrumentActive(9)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_219653_gZ, note - 24);
            }
            if (this.isInstrumentActive(12)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_219664_hc, note - 24);
            }
            if (this.isInstrumentActive(13)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_219665_hd, note - 24);
            }
            if (this.isInstrumentActive(14)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_189107_dL, note - 24);
            }
            if (this.isInstrumentActive(15)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_187682_dG, note - 24);
            }
        }
        if (note > 36 && note <= 60) {
            if (this.isInstrumentActive(5)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_193809_ey, note - 36);
            }
            if (this.isInstrumentActive(10)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_219662_ha, note - 36);
            }
        }
        if (note > 48) {
            if (this.isInstrumentActive(4)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_193807_ew, note - 48);
            }
            if (this.isInstrumentActive(8)) {
                SpeakerTileEntity.playNote(this.field_145850_b, this.field_174879_c, SoundEvents.field_193785_eE, note - 48);
            }
        }
    }

    public static void playNote(World world, BlockPos pos, SoundEvent evt, int note) {
        if (note < 0) {
            return;
        }
        float f = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
        if (latestNotes < (Integer)Config.MIDI_NOTES_PER_SECOND.get()) {
            world.func_184133_a((PlayerEntity)null, pos, evt, SoundCategory.RECORDS, 3.0f, f);
            ++latestNotes;
        }
    }

    @Override
    public void updateData(int encoded) {
        this.instruments = encoded;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.instruments = nbt.func_74762_e("instruments");
        super.func_230337_a_(state, nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74768_a("instruments", this.instruments);
        return super.func_189515_b(nbt);
    }

    private int getBit(int n, int k) {
        return n >> k & 1;
    }

    public boolean isInstrumentActive(int index) {
        return this.getBit(this.instruments, index) > 0;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT update = this.func_189517_E_();
        int data = 0;
        return new SUpdateTileEntityPacket(this.field_174879_c, data, update);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        CompoundNBT update = pkt.func_148857_g();
        this.handleUpdateTag(this.func_195044_w(), update);
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return nbt;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT nbt) {
        this.func_230337_a_(state, nbt);
    }
}

