/*
 * Decompiled with CFR 0.152.
 */
package c4.colorfulpotions;

import c4.colorfulpotions.common.recipe.RecipePotionDyes;
import c4.colorfulpotions.common.recipe.RecipeTippedArrowAlter;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod(modid="colorfulpotions", name="Colorful Potions", version="1.12.2-1.1", dependencies="required-after:forge@[14.23.5.2768,)", acceptedMinecraftVersions="[1.12, 1.13)", certificateFingerprint="5d5b8aee896a4f5ea3f3114784742662a67ad32f")
public class ColorfulPotions {
    public static final String MODID = "colorfulpotions";
    public static final String NAME = "Colorful Potions";

    @Mod.EventHandler
    public void onFingerPrintViolation(FMLFingerprintViolationEvent evt) {
        FMLLog.log.log(Level.ERROR, "Invalid fingerprint detected! The file " + evt.getSource().getName() + " may have been tampered with. This version will NOT be supported by the author!");
    }

    @Mod.EventBusSubscriber(modid="colorfulpotions", value={Side.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onPotionTooltip(ItemTooltipEvent evt) {
            NBTTagCompound nbttagcompound;
            ItemStack stack = evt.getItemStack();
            if ((stack.func_77973_b() instanceof ItemPotion || stack.func_77973_b() instanceof ItemTippedArrow) && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("CustomPotionColor", 99)) {
                List tooltip = evt.getToolTip();
                if (evt.getFlags().func_194127_a()) {
                    tooltip.add(I18n.func_135052_a((String)"item.color", (Object[])new Object[]{String.format("#%06X", nbttagcompound.func_74762_e("CustomPotionColor"))}));
                } else {
                    tooltip.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"item.dyed", (Object[])new Object[0]));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="colorfulpotions")
    public static class RegistryEvents {
        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> evt) {
            evt.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipe[]{new RecipePotionDyes(), new RecipeTippedArrowAlter()});
        }
    }
}

