/*
 * Decompiled with CFR 0.152.
 */
package mod.upcraftlp.colorfulsheep;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="colorful-sheep", name="craftdevmods/colorful-sheep")
@Config.LangKey(value="config.colorful-sheep.title")
public class ModConfig {
    @Config.Comment(value={"A list of all colors plus their relative spawn weight"})
    public static Map<String, Double> WEIGHTS = Maps.newConcurrentMap();

    static {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String name = color.name();
            if (color == EnumDyeColor.WHITE) {
                WEIGHTS.put(name, 50.0);
                continue;
            }
            if (color == EnumDyeColor.BLACK || color == EnumDyeColor.GRAY || color == EnumDyeColor.SILVER) {
                WEIGHTS.put(name, 5.0);
                continue;
            }
            if (color == EnumDyeColor.BROWN) {
                WEIGHTS.put(name, 3.0);
                continue;
            }
            if (color == EnumDyeColor.PINK) {
                WEIGHTS.put(name, 1.0);
                continue;
            }
            WEIGHTS.put(name, 2.0);
        }
    }

    @Mod.EventBusSubscriber(modid="colorful-sheep")
    public static class Handler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("colorful-sheep")) {
                ConfigManager.sync((String)"colorful-sheep", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }
}

