/*
 * Decompiled with CFR 0.152.
 */
package mod.upcraftlp.colorfulsheep;

import com.google.common.collect.Maps;
import java.util.Map;
import mod.upcraftlp.colorfulsheep.ModConfig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="colorful-sheep")
public class SheepSpawnHandler {
    private static final Map<Integer, EnumDyeColor> COLOR_QUEUE = Maps.newConcurrentMap();

    @SubscribeEvent
    public static void onUpdateEntity(LivingEvent.LivingUpdateEvent event) {
        EntitySheep sheep;
        int id;
        if (event.getEntityLiving() instanceof EntitySheep && COLOR_QUEUE.containsKey(id = (sheep = (EntitySheep)event.getEntityLiving()).func_145782_y())) {
            sheep.func_175512_b(COLOR_QUEUE.get(sheep.func_145782_y()));
            COLOR_QUEUE.remove(id);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpawnSheep(LivingSpawnEvent.CheckSpawn event) {
        EntitySheep sheep;
        if (event.getWorld() instanceof WorldServer && event.getEntityLiving() instanceof EntitySheep && !(sheep = (EntitySheep)event.getEntityLiving()).func_70631_g_()) {
            double completeWeight = 0.0;
            for (String color : ModConfig.WEIGHTS.keySet()) {
                completeWeight += ModConfig.WEIGHTS.get(color).doubleValue();
            }
            double result = sheep.func_70681_au().nextDouble() * completeWeight;
            double countWeight = 0.0;
            for (String color : ModConfig.WEIGHTS.keySet()) {
                if (!((countWeight += ModConfig.WEIGHTS.get(color).doubleValue()) >= result)) continue;
                COLOR_QUEUE.put(sheep.func_145782_y(), EnumDyeColor.valueOf((String)color));
                break;
            }
        }
    }
}

