/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOres;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.SimplePlacement;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompactOreWorldGen {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init(List<CompactOre> ores) {
        HashMap normalGeneratingOresByProbability = new HashMap();
        HashMap lateGeneratingOresByProbability = new HashMap();
        for (CompactOre ore : ores) {
            HashMap m;
            if (!ore.isReal() || ore.getBaseBlock() == null) continue;
            HashMap<Float, HashSet<Object>> hashMap = m = ore.isLateGeneration() ? lateGeneratingOresByProbability : normalGeneratingOresByProbability;
            if (!m.containsKey(Float.valueOf(ore.getSpawnProbability()))) {
                m.put(Float.valueOf(ore.getSpawnProbability()), new HashSet());
            }
            ((Set)m.get(Float.valueOf(ore.getSpawnProbability()))).add(ore);
        }
        Set<ConfiguredFeature> normalGeneratingConfiguredFeatures = normalGeneratingOresByProbability.keySet().stream().map(prob -> CompactOreWorldGen.make(prob.floatValue(), (Set)normalGeneratingOresByProbability.get(prob))).collect(Collectors.toSet());
        Set<ConfiguredFeature> lateGeneratingConfiguredFeatures = lateGeneratingOresByProbability.keySet().stream().map(prob -> CompactOreWorldGen.make(prob.floatValue(), (Set)lateGeneratingOresByProbability.get(prob))).collect(Collectors.toSet());
        LOGGER.info("Registering " + (normalGeneratingConfiguredFeatures.size() + lateGeneratingConfiguredFeatures.size()) + " world generation features (" + normalGeneratingConfiguredFeatures.size() + " normal, " + lateGeneratingConfiguredFeatures.size() + " late)");
        for (Biome biome : ForgeRegistries.BIOMES) {
            normalGeneratingConfiguredFeatures.forEach(feature -> biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, feature));
            lateGeneratingConfiguredFeatures.forEach(feature -> biome.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, feature));
        }
    }

    private static ConfiguredFeature<?, ?> make(float prob, Set<CompactOre> ores) {
        return new ConfiguredFeature((Feature)CompactOres.MULTI_REPLACE_BLOCK.get(), (IFeatureConfig)new MultiReplaceBlockConfig(ores.stream().collect(Collectors.toMap(ore -> ore.getBaseBlock().func_176223_P(), ore -> (BlockState)((CompactOreBlock)CompactOres.COMPACT_ORE.get()).func_176223_P().func_206870_a(CompactOreBlock.ORE_PROPERTY, (Comparable)ore))))).func_227228_a_(new ConfiguredPlacement((Placement)CompactOres.ALL_WITH_PROBABILITY.get(), (IPlacementConfig)new ProbabilityConfig(prob)));
    }

    public static class MultiReplaceBlockFeature
    extends Feature<MultiReplaceBlockConfig> {
        public MultiReplaceBlockFeature(Function<Dynamic<?>, ? extends MultiReplaceBlockConfig> arg0) {
            super(arg0);
        }

        public boolean place(IWorld worldIn, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos pos, MultiReplaceBlockConfig config) {
            if (config.replacementMap.containsKey(worldIn.func_180495_p(pos))) {
                worldIn.func_180501_a(pos, config.replacementMap.get(worldIn.func_180495_p(pos)), 2);
            }
            return true;
        }
    }

    public static class MultiReplaceBlockConfig
    implements IFeatureConfig {
        public final Map<BlockState, BlockState> replacementMap;

        public MultiReplaceBlockConfig(Map<BlockState, BlockState> replacementMap) {
            this.replacementMap = Collections.unmodifiableMap(replacementMap);
        }

        public <T> Dynamic<T> func_214634_a(DynamicOps<T> ops) {
            HashMap<Object, Object> serMap = new HashMap<Object, Object>();
            for (BlockState key : this.replacementMap.keySet()) {
                serMap.put(BlockState.func_215689_a(ops, (BlockState)key).getValue(), BlockState.func_215689_a(ops, (BlockState)this.replacementMap.get(key)).getValue());
            }
            return new Dynamic(ops, ops.createMap((Map)ImmutableMap.of((Object)ops.createString("replacements"), (Object)ops.createMap(serMap))));
        }

        public static <T> MultiReplaceBlockConfig deserialize(Dynamic<T> d) {
            return new MultiReplaceBlockConfig(d.get("replacements").asMap(BlockState::func_215698_a, BlockState::func_215698_a));
        }
    }

    public static class AllWithProbability
    extends SimplePlacement<ProbabilityConfig> {
        public AllWithProbability(Function<Dynamic<?>, ? extends ProbabilityConfig> p_i51362_1_) {
            super(p_i51362_1_);
        }

        protected Stream<BlockPos> getPositions(Random random, ProbabilityConfig probabilityConfig, BlockPos blockPos) {
            Stream.Builder<BlockPos> builder = Stream.builder();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 256; ++y) {
                        if (!(random.nextFloat() <= probabilityConfig.probability)) continue;
                        builder.add(blockPos.func_177982_a(x, y, z));
                    }
                }
            }
            return builder.build();
        }
    }

    public static class ProbabilityConfig
    implements IPlacementConfig {
        public final float probability;

        public ProbabilityConfig(float probability) {
            this.probability = probability;
        }

        public <T> Dynamic<T> func_214719_a(DynamicOps<T> dynamicOps) {
            return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("probability"), (Object)dynamicOps.createFloat(this.probability))));
        }

        public static ProbabilityConfig deserialize(Dynamic<?> dynamic) {
            return new ProbabilityConfig(dynamic.get("probability").asFloat(0.1f));
        }
    }
}

