/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOreBlockItem;
import doublenegation.mods.compactores.CompactOreTexture;
import doublenegation.mods.compactores.CompactOreTileEntity;
import doublenegation.mods.compactores.CompactOreWorldGen;
import doublenegation.mods.compactores.CompactOresResourcePack;
import doublenegation.mods.compactores.OreListSync;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigLoader;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="compactores")
public class CompactOres {
    public static final String MODID = "compactores";
    public static final Logger LOGGER = LogManager.getLogger();
    private static final DeferredRegister<Block> BLOCKS = new DeferredRegister(ForgeRegistries.BLOCKS, "compactores");
    private static final DeferredRegister<Item> ITEMS = new DeferredRegister(ForgeRegistries.ITEMS, "compactores");
    private static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = new DeferredRegister(ForgeRegistries.TILE_ENTITIES, "compactores");
    private static final DeferredRegister<Placement<?>> DECORATORS = new DeferredRegister(ForgeRegistries.DECORATORS, "compactores");
    private static final DeferredRegister<Feature<?>> FEATURES = new DeferredRegister(ForgeRegistries.FEATURES, "compactores");
    public static final RegistryObject<CompactOreBlock> COMPACT_ORE = BLOCKS.register("compact_ore", CompactOreBlock::new);
    public static final RegistryObject<CompactOreBlockItem> COMPACT_ORE_ITEM = ITEMS.register("compact_ore", () -> new CompactOreBlockItem((Block)COMPACT_ORE.get()));
    public static final RegistryObject<TileEntityType<CompactOreTileEntity>> COMPACT_ORE_TE = TILE_ENTITIES.register("compact_ore", () -> TileEntityType.Builder.func_223042_a(CompactOreTileEntity::new, (Block[])new Block[0]).func_206865_a(null));
    public static final RegistryObject<CompactOreWorldGen.AllWithProbability> ALL_WITH_PROBABILITY = DECORATORS.register("all_with_probability", () -> new CompactOreWorldGen.AllWithProbability(CompactOreWorldGen.ProbabilityConfig::deserialize));
    public static final RegistryObject<CompactOreWorldGen.MultiReplaceBlockFeature> MULTI_REPLACE_BLOCK = FEATURES.register("multi_replace_block", () -> new CompactOreWorldGen.MultiReplaceBlockFeature(CompactOreWorldGen.MultiReplaceBlockConfig::deserialize));
    private static List<CompactOre> compactOres;
    private static CompactOresResourcePack resourcePack;
    private static Utils.ReturningScreen loadFinishScreen;
    private static Timer loadFinishTimer;
    private static ItemGroup itemGroup;

    public CompactOres() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::startServer);
        MinecraftForge.EVENT_BUS.addListener(this::onBlockBroken);
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> MinecraftForge.EVENT_BUS.addListener(this::onPlayerJoin));
        compactOres = ConfigLoader.loadOres();
        compactOres.add(0, new CompactOre());
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        DECORATORS.register(FMLJavaModLoadingContext.get().getModEventBus());
        FEATURES.register(FMLJavaModLoadingContext.get().getModEventBus());
        resourcePack = new CompactOresResourcePack(CompactOres::compactOres);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            LOGGER.info("Attaching CompactOre resources to the Minecraft client");
            Minecraft.func_71410_x().func_195548_H().func_198982_a((IPackFinder)resourcePack);
            CompactOreTexture.registerCacheInvalidator();
        });
        OreListSync.init();
        if (ModList.get().isLoaded("oreexcavation")) {
            try {
                Class<?> clazz = Class.forName("doublenegation.mods.compactores.compat.OreExcavationIntegration");
                clazz.getDeclaredMethod("init", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static List<CompactOre> compactOres() {
        return compactOres;
    }

    public static CompactOre getFor(ResourceLocation baseBlockLoc) {
        for (CompactOre ore : compactOres) {
            if (!ore.getBaseBlockRegistryName().equals((Object)baseBlockLoc)) continue;
            return ore;
        }
        return null;
    }

    public static CompactOre getForResourceName(String resourceName) {
        for (CompactOre ore : compactOres) {
            if (!ore.func_176610_l().equals(resourceName)) continue;
            return ore;
        }
        return null;
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        CompactOreWorldGen.init(compactOres);
    }

    public static ItemGroup getItemGroup() {
        return itemGroup;
    }

    public void startServer(FMLServerAboutToStartEvent event) {
        LOGGER.info("Attaching CompactOre resources to the Minecraft server");
        event.getServer().func_195561_aH().func_198982_a((IPackFinder)resourcePack);
    }

    public void onBlockBroken(BlockEvent.BreakEvent breakEvent) {
        BlockState state = breakEvent.getState();
        if (!state.func_177230_c().equals(COMPACT_ORE.get())) {
            return;
        }
        CompactOre ore = (CompactOre)state.func_177229_b(CompactOreBlock.ORE_PROPERTY);
        int numEvents = ore.getMinRolls() + breakEvent.getWorld().func_201674_k().nextInt(ore.getMaxRolls() - ore.getMinRolls() + 1);
        for (int i = 0; i < numEvents; ++i) {
            MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent((World)breakEvent.getWorld(), breakEvent.getPos(), ore.getBaseBlock().func_176223_P(), breakEvent.getPlayer()));
        }
    }

    public void onPlayerJoin(EntityJoinWorldEvent ev) {
        if (ev.getEntity() instanceof ServerPlayerEntity) {
            OreListSync.sendListToClient((ServerPlayerEntity)ev.getEntity(), CompactOres.compactOres());
        }
    }

    public static void setLoadFinishScreen(Object screen) {
        if (!(screen instanceof Utils.ReturningScreen)) {
            return;
        }
        loadFinishScreen = (Utils.ReturningScreen)((Object)screen);
        if (loadFinishTimer == null) {
            loadFinishTimer = new Timer();
            loadFinishTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (Minecraft.func_71410_x().field_71462_r instanceof MainMenuScreen) {
                        LOGGER.info("Main menu entered - switching to Compact Ores config notification screen");
                        loadFinishTimer.cancel();
                        Minecraft.func_71410_x().func_212871_a_(() -> {
                            Screen returnScreen = Minecraft.func_71410_x().field_71462_r;
                            loadFinishScreen.setReturnTarget(returnScreen);
                            Minecraft.func_71410_x().func_147108_a((Screen)loadFinishScreen);
                        });
                    }
                }
            }, 100L, 100L);
        }
    }

    static {
        itemGroup = new ItemGroup(MODID){

            public ItemStack func_78016_d() {
                return ((CompactOreBlockItem)COMPACT_ORE_ITEM.get()).getStackOfOre((CompactOre)compactOres.get(1), 1);
            }
        };
    }
}

