/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOres;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class OreListSync {
    private static final String PROTOCOL_VERSION = "1";
    private static final String CHANNEL_NAME = "oresync";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("compactores", "oresync"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, OreListMessage.class, OreListMessage::encode, OreListMessage::decode, OreListSync::handle);
    }

    public static void sendListToClient(ServerPlayerEntity player, List<CompactOre> oreList) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OreListMessage(oreList));
    }

    public static void handle(OreListMessage msg, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OreListSync.lambda$null$3((Supplier)ctx, msg));
    }

    private static /* synthetic */ void lambda$null$3(Supplier ctx, OreListMessage msg) {
        ((NetworkEvent.Context)ctx.get()).enqueueWork(() -> {
            if (!msg.matchesLocalList()) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("chat.compactores.desync_warning", new Object[0]));
            }
        });
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }

    public static class OreListMessage {
        private List<String> oreList;

        public OreListMessage(List<CompactOre> ores) {
            this.oreList = ores.stream().filter(CompactOre::isReal).map(ore -> CompactOreBlock.ORE_PROPERTY.func_177702_a((Comparable)ore)).collect(Collectors.toList());
        }

        private OreListMessage(String oreList) {
            this.oreList = Arrays.asList(oreList.split(","));
        }

        public boolean matchesLocalList() {
            List<String> localOreList = new OreListMessage(CompactOres.compactOres()).oreList;
            return localOreList.equals(this.oreList);
        }

        public void encode(PacketBuffer buf) {
            buf.func_180714_a(String.join((CharSequence)",", this.oreList));
        }

        public static OreListMessage decode(PacketBuffer buf) {
            return new OreListMessage(buf.func_218666_n());
        }
    }
}

