/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.compat;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.CompactOreBlock;
import doublenegation.mods.compactores.CompactOres;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraftforge.common.MinecraftForge;
import oreexcavation.events.EventExcavate;
import oreexcavation.groups.BlockEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OreExcavationIntegration {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void init() {
        MinecraftForge.EVENT_BUS.addListener(OreExcavationIntegration::onExcavate);
        LOGGER.info("Registered Compact Ores Ore Excavation integration");
    }

    public static void onExcavate(EventExcavate.Pre excavateEvent) {
        ArrayList<BlockEntry> entries = new ArrayList<BlockEntry>(excavateEvent.getAgent().blockGroup);
        if (entries.size() == 0) {
            entries.add(new BlockEntry(excavateEvent.getAgent().state));
        }
        for (BlockEntry entry : entries) {
            CompactOre ore = CompactOres.getFor(entry.idName);
            if (ore == null) continue;
            LOGGER.info("Excavating " + entry.idName + ", which has a compact variant - adding compact variant to block group");
            excavateEvent.getAgent().blockGroup.add(new StrictlyMatchingBlockStateEntry((BlockState)((CompactOreBlock)CompactOres.COMPACT_ORE.get()).func_176223_P().func_206870_a(CompactOreBlock.ORE_PROPERTY, (Comparable)ore)));
        }
    }

    public static class StrictlyMatchingBlockStateEntry
    extends BlockEntry {
        public StrictlyMatchingBlockStateEntry(BlockState state) {
            super(state);
        }

        public boolean checkMatch(BlockState blockState) {
            return this.state.equals(blockState);
        }
    }
}

