/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableMap;
import doublenegation.mods.compactores.CompactOres;
import doublenegation.mods.compactores.config.ConfigLoadingFailedScreen;
import doublenegation.mods.compactores.config.ConfigUpdateConfirmScreen;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigFileManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private Path configDir;
    private Path definitionConfigDir;
    private Path customizationConfigDir;
    private Path versionConfig;
    private CommentedFileConfig configVersionConfig;
    private Set<FileConfig> definitionConfigs = new HashSet<FileConfig>();
    private Set<FileConfig> customizationConfigs = new HashSet<FileConfig>();

    public ConfigFileManager() {
        Path forgeConfigDir = FMLPaths.CONFIGDIR.get();
        this.configDir = forgeConfigDir.resolve("compactores");
        this.definitionConfigDir = this.configDir.resolve("definitions");
        this.customizationConfigDir = this.configDir.resolve("customizations");
        this.versionConfig = this.configDir.resolve("README.toml");
    }

    public void load() {
        boolean generateNewConfig;
        this.requireDirectory(this.configDir);
        this.requireDirectory(this.definitionConfigDir);
        this.requireDirectory(this.customizationConfigDir);
        boolean bl = generateNewConfig = !Files.exists(this.versionConfig, new LinkOption[0]);
        if (!(generateNewConfig || Files.isRegularFile(this.versionConfig, new LinkOption[0]) && Files.isReadable(this.versionConfig))) {
            throw new RuntimeException("Unable to initialize compactores config: Version config (.minecraft/config/compactores/README.toml) is invalid!");
        }
        if (!generateNewConfig) {
            boolean bl2 = generateNewConfig = !this.loadVersionConfig(this.versionConfig);
            if (generateNewConfig) {
                this.configVersionConfig.close();
            }
        }
        if (generateNewConfig) {
            LOGGER.info("No valid configuration was found - generating new default configuration...");
            this.cleanOldConfigs(this.definitionConfigDir);
            this.cleanOldConfigs(this.customizationConfigDir);
            this.exportDefaultConfig((Map<String, Path>)ImmutableMap.of((Object)"definitions", (Object)this.definitionConfigDir, (Object)"customizations", (Object)this.customizationConfigDir));
            this.writeVersionConfig(this.versionConfig);
            LOGGER.info("Configuration generated!");
        }
        LOGGER.info("Loading configuration files...");
        this.loadConfigFiles(this.definitionConfigDir, this.definitionConfigs);
        LOGGER.info("Loaded " + this.definitionConfigs.size() + " ore definition files");
        this.loadConfigFiles(this.customizationConfigDir, this.customizationConfigs);
        LOGGER.info("Loaded " + this.customizationConfigs.size() + " ore customization files");
        LOGGER.info("Configuration files loaded successfully!");
    }

    private void requireDirectory(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectory(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to initialize compactores configs: Unable to create directory " + dir + ", reason: " + e.getClass().getName() + ": " + e.getMessage());
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new RuntimeException("Unable to initialize compactores configs: Expected directory, but found other object at " + dir);
        }
    }

    private boolean loadVersionConfig(Path loc) {
        this.configVersionConfig = CommentedFileConfig.of((Path)loc);
        this.configVersionConfig.load();
        if (!this.configVersionConfig.contains("versions") || !(this.configVersionConfig.get("versions") instanceof Config)) {
            return false;
        }
        Config versions = (Config)this.configVersionConfig.get("versions");
        if (!versions.contains("created") || !(versions.get("created") instanceof String)) {
            return false;
        }
        String created = (String)versions.get("created");
        if (!versions.contains("updated") || !(versions.get("updated") instanceof String)) {
            return false;
        }
        String updated = (String)versions.get("updated");
        String active = this.getOwnVersion();
        if (!active.equals(created) && !active.equals(updated)) {
            LOGGER.warn("WARNING");
            LOGGER.warn("~~~~~~~");
            LOGGER.warn("Your current Compact Ores configuration is based on an outdated version of");
            LOGGER.warn("the Compact Ores default config. Please consider generating a new version");
            LOGGER.warn("of the default config by deleting the .minecraft/config/compactores directory");
            LOGGER.warn("config version: " + created + "      mod version: " + active);
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> CompactOres.setLoadFinishScreen((Object)new ConfigUpdateConfirmScreen(created, active, btn -> {
                LOGGER.info("Updating configuration...");
                this.cleanOldConfigs(this.definitionConfigDir);
                this.cleanOldConfigs(this.customizationConfigDir);
                this.exportDefaultConfig((Map<String, Path>)ImmutableMap.of((Object)"definitions", (Object)this.definitionConfigDir, (Object)"customizations", (Object)this.customizationConfigDir));
                this.configVersionConfig.close();
                this.writeVersionConfig(this.versionConfig);
                this.configVersionConfig = CommentedFileConfig.of((Path)this.versionConfig);
                this.configVersionConfig.load();
                Minecraft.func_71410_x().func_71400_g();
            }, btn -> {
                LOGGER.info("Not updating configuration - writing new version to version config...");
                versions.set("updated", (Object)active);
                this.configVersionConfig.save();
                if (Minecraft.func_71410_x().field_71462_r != null) {
                    ((ConfigUpdateConfirmScreen)Minecraft.func_71410_x().field_71462_r).returnToPreviousScreen();
                }
            })));
        }
        return true;
    }

    private String getOwnVersion() {
        Optional mod = ModList.get().getModContainerById("compactores");
        if (!mod.isPresent()) {
            throw new RuntimeException("Mod compactores couldn't find itself in the mod list - this should never happen.");
        }
        return ((ModContainer)mod.get()).getModInfo().getVersion().toString();
    }

    private void cleanOldConfigs(Path directory) {
        try {
            Files.list(directory).filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.toString().toLowerCase(Locale.ROOT).endsWith(".toml")).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to initialize compactores configs: When deleting outdated configs: " + e.getClass().getName() + ": " + e.getMessage());
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize compactores configs: When deleting outdated configs: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private void writeVersionConfig(Path versionConfigPath) {
        this.configVersionConfig = CommentedFileConfig.of((Path)versionConfigPath);
        CommentedConfig versionCfg = CommentedConfig.inMemory();
        String version = this.getOwnVersion();
        versionCfg.add("created", (Object)version);
        versionCfg.add("updated", (Object)version);
        this.configVersionConfig.add("versions", (Object)versionCfg);
        this.configVersionConfig.setComment("versions", this.getConfigReadme());
        this.configVersionConfig.save();
    }

    /*
     * Exception decompiling
     */
    private String getConfigReadme() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void exportDefaultConfig(Map<String, Path> exports) {
        ArrayList<String> modids = new ArrayList<String>();
        try (InputStream is = this.getClass().getResourceAsStream("/assets/compactores/default_config/modid_list.txt");){
            Scanner sc = new Scanner(is);
            Object object = null;
            try {
                while (sc.hasNextLine()) {
                    String line = sc.nextLine();
                    if (line.isEmpty()) continue;
                    modids.add(line);
                }
            }
            catch (Throwable line) {
                object = line;
                throw line;
            }
            finally {
                if (sc != null) {
                    if (object != null) {
                        try {
                            sc.close();
                        }
                        catch (Throwable line) {
                            ((Throwable)object).addSuppressed(line);
                        }
                    } else {
                        sc.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize compactores configs: When preparing to export default configs: " + e.getClass().getName() + ": " + e.getMessage());
        }
        for (String k : exports.keySet()) {
            Path targetDir = exports.get(k);
            for (String modid : modids) {
                Path targetFile = targetDir.resolve(modid + ".toml");
                URL sourceFile = this.getClass().getResource("/assets/compactores/default_config/" + k + "/" + modid + ".toml");
                LOGGER.debug("Exporting default config file: " + sourceFile.toExternalForm() + " -> " + targetFile.toAbsolutePath().toString());
                try {
                    Files.copy(sourceFile.openStream(), targetFile, new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to initialize compactores config: Failed to copy default configuration files: " + e.getClass().getName() + ": " + e.getMessage());
                }
            }
        }
    }

    private void loadConfigFiles(Path sourceDir, Set<FileConfig> destination) {
        try {
            Files.list(sourceDir).filter(p -> Files.isRegularFile(p, new LinkOption[0])).filter(p -> p.toString().toLowerCase(Locale.ROOT).endsWith(".toml")).forEach(p -> {
                FileConfig cfg = FileConfig.of((Path)p);
                cfg.load();
                destination.add(cfg);
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load compactores config: " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public Set<FileConfig> getDefinitionConfigs() {
        return Collections.unmodifiableSet(this.definitionConfigs);
    }

    public Set<FileConfig> getCustomizationConfigs() {
        return Collections.unmodifiableSet(this.customizationConfigs);
    }

    public void handleConfigLoadingFailed(Exception e) {
        String msg = e.getClass().getName() + ": " + e.getMessage();
        LOGGER.error("Config loading failed: " + msg);
        DistExecutor.runForDist(() -> () -> {
            CompactOres.setLoadFinishScreen((Object)new ConfigLoadingFailedScreen(msg, btn -> Minecraft.func_71410_x().func_71400_g(), btn -> {
                LOGGER.info("Resetting configuration...");
                this.cleanOldConfigs(this.definitionConfigDir);
                this.cleanOldConfigs(this.customizationConfigDir);
                this.exportDefaultConfig((Map<String, Path>)ImmutableMap.of((Object)"definitions", (Object)this.definitionConfigDir, (Object)"customizations", (Object)this.customizationConfigDir));
                this.configVersionConfig.close();
                this.writeVersionConfig(this.versionConfig);
                Minecraft.func_71410_x().func_71400_g();
            }));
            return null;
        }, () -> () -> {
            LOGGER.error((Object)e);
            throw new IllegalStateException("Failed to load Compact Ores config. See log for stack trace. Error: " + msg);
        });
    }
}

