/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import doublenegation.mods.compactores.CompactOre;
import net.minecraft.util.ResourceLocation;

public class OreBuilder {
    private static boolean G_GENERATETEXTURE = true;
    private static int G_MAXORELAYERCOLORDIFF = 50;
    private static int G_MINROLLS = 3;
    private static int G_MAXROLLS = 5;
    private static float G_SPAWNPROBABILITY = 0.1f;
    private Boolean L_GENERATETEXTURE;
    private Integer L_MAXORELAYERCOLORDIFF;
    private ResourceLocation L_ORETEXTURE;
    private ResourceLocation L_ROCKTEXTURE;
    private boolean L_LATEGENRATION;
    private boolean L_USEGETDROPS;
    private Integer L_MINROLLS;
    private Integer L_MAXROLLS;
    private Float L_SPAWNPROBABILITY;
    private Boolean generateTexture;
    private Integer maxOreLayerColorDiff;
    private ResourceLocation oreTexture;
    private ResourceLocation rockTexture;
    private Boolean lateGeneration;
    private Boolean useGetDrops;
    private Integer minRolls;
    private Integer maxRolls;
    private Float spawnProbability;
    private ResourceLocation baseBlock;

    public static void setGlobalGenerateTexture(boolean value) {
        G_GENERATETEXTURE = value;
    }

    public static void setGlobalMaxOreLayerColorDiff(int value) {
        G_MAXORELAYERCOLORDIFF = value;
    }

    public static void setGlobalMinRolls(int value) {
        G_MINROLLS = value;
    }

    public static void setGlobalMaxRolls(int value) {
        G_MAXROLLS = value;
    }

    public static void setGlobalSpawnProbability(float value) {
        G_SPAWNPROBABILITY = value;
    }

    private OreBuilder(Boolean localGenerateTexture, Integer localMaxOreLayerColorDiff, ResourceLocation localOreTexture, ResourceLocation localRockTexture, Boolean localLateGeneration, Boolean localUseGetDrops, Integer localMinRolls, Integer localMaxRolls, Float localSpawnProbability) {
        this.L_GENERATETEXTURE = localGenerateTexture;
        this.L_MAXORELAYERCOLORDIFF = localMaxOreLayerColorDiff;
        this.L_ORETEXTURE = localOreTexture;
        this.L_ROCKTEXTURE = localRockTexture;
        this.L_LATEGENRATION = localLateGeneration;
        this.L_USEGETDROPS = localUseGetDrops;
        this.L_MINROLLS = localMinRolls;
        this.L_MAXROLLS = localMaxRolls;
        this.L_SPAWNPROBABILITY = localSpawnProbability;
    }

    public OreBuilder generateTexture(Boolean generateTexture) {
        this.generateTexture = generateTexture;
        return this;
    }

    public OreBuilder maxOreLayerColorDiff(Integer maxOreLayerColorDiff) {
        this.maxOreLayerColorDiff = maxOreLayerColorDiff;
        return this;
    }

    public OreBuilder oreTexture(ResourceLocation oreTexture) {
        this.oreTexture = oreTexture;
        return this;
    }

    public OreBuilder rockTexture(ResourceLocation rockTexture) {
        this.rockTexture = rockTexture;
        return this;
    }

    public OreBuilder lateGeneration(Boolean lateGeneration) {
        this.lateGeneration = lateGeneration;
        return this;
    }

    public OreBuilder useGetDrops(Boolean useGetDrops) {
        this.useGetDrops = useGetDrops;
        return this;
    }

    public OreBuilder minRolls(Integer minRolls) {
        this.minRolls = minRolls;
        return this;
    }

    public OreBuilder maxRolls(Integer maxRolls) {
        this.maxRolls = maxRolls;
        return this;
    }

    public OreBuilder spawnProbability(Float spawnProbability) {
        this.spawnProbability = spawnProbability;
        return this;
    }

    public OreBuilder baseBlock(ResourceLocation baseBlock) {
        this.baseBlock = baseBlock;
        return this;
    }

    public CompactOre build() {
        int actualMaxRolls;
        int actualMinRolls;
        boolean actualUseGetDrops;
        boolean actualGenerateTexture;
        if (this.baseBlock == null) {
            throw new IllegalArgumentException("Can not build ore: baseBlock is null.");
        }
        boolean bl = this.generateTexture != null ? this.generateTexture : (actualGenerateTexture = this.L_GENERATETEXTURE != null ? this.L_GENERATETEXTURE : G_GENERATETEXTURE);
        int actualMaxOreLayerColorDiff = this.maxOreLayerColorDiff != null ? this.maxOreLayerColorDiff : (this.L_MAXORELAYERCOLORDIFF != null ? this.L_MAXORELAYERCOLORDIFF : G_MAXORELAYERCOLORDIFF);
        ResourceLocation actualOreTexture = this.oreTexture != null ? this.oreTexture : this.L_ORETEXTURE;
        ResourceLocation actualRockTexture = this.rockTexture != null ? this.rockTexture : this.L_ROCKTEXTURE;
        boolean actualLateGeneration = this.lateGeneration != null ? this.lateGeneration : this.L_LATEGENRATION;
        boolean bl2 = actualUseGetDrops = this.useGetDrops != null ? this.useGetDrops : this.L_USEGETDROPS;
        int n = this.minRolls != null ? this.minRolls : (actualMinRolls = this.L_MINROLLS != null ? this.L_MINROLLS : G_MINROLLS);
        int n2 = this.maxRolls != null ? this.maxRolls : (actualMaxRolls = this.L_MAXROLLS != null ? this.L_MAXROLLS : G_MAXROLLS);
        float actualSpawnProbability = this.spawnProbability != null ? this.spawnProbability.floatValue() : (this.L_SPAWNPROBABILITY != null ? this.L_SPAWNPROBABILITY.floatValue() : G_SPAWNPROBABILITY);
        return new CompactOre(this.baseBlock, actualMinRolls, actualMaxRolls, actualOreTexture, actualRockTexture, actualSpawnProbability, actualMaxOreLayerColorDiff, actualLateGeneration, actualGenerateTexture, actualUseGetDrops);
    }

    public static class Factory {
        private Boolean generateTexture;
        private Integer maxOreLayerColorDiff;
        private ResourceLocation oreTexture;
        private ResourceLocation rockTexture;
        private boolean lateGeneration = false;
        private boolean useGetDrops = false;
        private Integer minRolls;
        private Integer maxRolls;
        private Float spawnProbability;

        private Factory() {
        }

        public static Factory createFactory() {
            return new Factory();
        }

        public Factory generateTexture(Boolean generateTexture) {
            this.generateTexture = generateTexture;
            return this;
        }

        public Factory maxOreLayerColorDiff(Integer maxOreLayerColorDiff) {
            this.maxOreLayerColorDiff = maxOreLayerColorDiff;
            return this;
        }

        public Factory oreTexture(ResourceLocation oreTexture) {
            this.oreTexture = oreTexture;
            return this;
        }

        public Factory rockTexture(ResourceLocation rockTexture) {
            this.rockTexture = rockTexture;
            return this;
        }

        public Factory lateGeneration(Boolean lateGeneration) {
            if (lateGeneration != null) {
                this.lateGeneration = lateGeneration;
            }
            return this;
        }

        public Factory useGetDrops(Boolean useGetDrops) {
            if (useGetDrops != null) {
                this.useGetDrops = useGetDrops;
            }
            return this;
        }

        public Factory minRolls(Integer minRolls) {
            this.minRolls = minRolls;
            return this;
        }

        public Factory maxRolls(Integer maxRolls) {
            this.maxRolls = maxRolls;
            return this;
        }

        public Factory spawnProbability(Float spawnProbability) {
            this.spawnProbability = spawnProbability;
            return this;
        }

        public OreBuilder create() {
            return new OreBuilder(this.generateTexture, this.maxOreLayerColorDiff, this.oreTexture, this.rockTexture, this.lateGeneration, this.useGetDrops, this.minRolls, this.maxRolls, this.spawnProbability);
        }
    }
}

