/*
 * Decompiled with CFR 0.152.
 */
package doublenegation.mods.compactores.config;

import doublenegation.mods.compactores.CompactOre;
import doublenegation.mods.compactores.Utils;
import doublenegation.mods.compactores.config.ConfigFile;
import doublenegation.mods.compactores.config.OreBuilder;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.util.ResourceLocation;

public class OreConfigHolder {
    private ResourceLocation oreName;
    private ConfigFile definitionConfig;
    private ConfigFile customizationConfig;
    private BiFunction<ConfigFile, ConfigFile, OreBuilder> oreBuilderProvider;

    public OreConfigHolder(ResourceLocation oreName, BiFunction<ConfigFile, ConfigFile, OreBuilder> oreBuilderProvider) {
        this.oreName = oreName;
        this.oreBuilderProvider = oreBuilderProvider;
    }

    public synchronized void setDefinitionConfig(ConfigFile definitionConfig) {
        if (this.definitionConfig != null) {
            throw new IllegalStateException("Definition config already set");
        }
        if (definitionConfig == null) {
            throw new IllegalArgumentException("config is null!");
        }
        if (definitionConfig.getType() != ConfigFile.Type.DEFINITION) {
            throw new IllegalArgumentException("Config file is not a definition config");
        }
        if (!definitionConfig.containsOre(this.oreName)) {
            throw new IllegalArgumentException("Config does not support ore (" + this.oreName + ")");
        }
        this.definitionConfig = definitionConfig;
    }

    public synchronized void setCustomizationConfig(ConfigFile customizationConfig) {
        if (this.customizationConfig != null) {
            throw new IllegalStateException("Customization config already set");
        }
        if (customizationConfig == null) {
            throw new IllegalArgumentException("config is null!");
        }
        if (customizationConfig.getType() != ConfigFile.Type.CUSTOMIZATION) {
            throw new IllegalArgumentException("Config file is not a customization config");
        }
        if (!customizationConfig.containsOre(this.oreName)) {
            throw new IllegalArgumentException("Config does not support ore (" + this.oreName + ")");
        }
        this.customizationConfig = customizationConfig;
    }

    public CompactOre buildOre() {
        if (this.definitionConfig == null) {
            throw new IllegalStateException("Definition config is not set");
        }
        return this.oreBuilderProvider.apply(this.definitionConfig, this.customizationConfig).generateTexture((Boolean)this.definitionConfig.getOreConfigValue(this.oreName, "generateTexture")).maxOreLayerColorDiff((Integer)this.definitionConfig.getOreConfigValue(this.oreName, "maxOreLayerColorDiff")).oreTexture(Utils.parseResourceLocationExtra((String)this.definitionConfig.getOreConfigValue(this.oreName, "oreTexture"), this.definitionConfig.getFilenameNamespace())).rockTexture(Utils.parseResourceLocationExtra((String)this.definitionConfig.getOreConfigValue(this.oreName, "rockTexture"), this.definitionConfig.getFilenameNamespace())).lateGeneration((Boolean)this.definitionConfig.getOreConfigValue(this.oreName, "lateGeneration")).useGetDrops((Boolean)this.definitionConfig.getOreConfigValue(this.oreName, "useGetDrops")).minRolls(Optional.ofNullable(this.customizationConfig).map(c -> c.getOreConfigValue(this.oreName, "minRolls")).orElse(null)).maxRolls(Optional.ofNullable(this.customizationConfig).map(c -> c.getOreConfigValue(this.oreName, "maxRolls")).orElse(null)).spawnProbability(Optional.ofNullable(this.customizationConfig).map(c -> c.getOreConfigValue(this.oreName, "spawnProbability")).map(v -> Float.valueOf((float)((Double)v).doubleValue())).orElse(null)).baseBlock(this.oreName).build();
    }
}

