/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.occlusionculling;

import dev.tr7zw.entityculling.occlusionculling.AxisAlignedBB;
import java.util.Arrays;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.Chunk;

public class OcclusionCullingInstance {
    private final int reach = 64;
    private final byte[] cache = new byte[524288];

    public boolean isAABBVisible(Vector3d aabbBlock, AxisAlignedBB aabb, Vector3d playerLoc, boolean entity) {
        try {
            if (entity) {
                aabb.maxx -= aabbBlock.field_72450_a;
                aabb.minx -= aabbBlock.field_72450_a;
                aabb.maxy -= aabbBlock.field_72448_b;
                aabb.miny -= aabbBlock.field_72448_b;
                aabb.maxz -= aabbBlock.field_72449_c;
                aabb.minz -= aabbBlock.field_72449_c;
            }
            aabbBlock = aabbBlock.func_178786_a((double)((int)playerLoc.field_72450_a), (double)((int)playerLoc.field_72448_b), (double)((int)playerLoc.field_72449_c));
            int maxX = (int)Math.ceil(aabbBlock.field_72450_a + aabb.maxx + 0.25);
            int maxY = (int)Math.ceil(aabbBlock.field_72448_b + aabb.maxy + 0.25);
            int maxZ = (int)Math.ceil(aabbBlock.field_72449_c + aabb.maxz + 0.25);
            int minX = (int)Math.floor(aabbBlock.field_72450_a + aabb.minx - 0.25);
            int minY = (int)Math.floor(aabbBlock.field_72448_b + aabb.miny - 0.25);
            int minZ = (int)Math.floor(aabbBlock.field_72449_c + aabb.minz - 0.25);
            for (int x = minX; x < maxX; ++x) {
                if (x != minX && x != maxX - 1) continue;
                for (int y = minY; y < maxY; ++y) {
                    if (y != minY && y != maxY - 1) continue;
                    for (int z = minZ; z < maxZ; ++z) {
                        if (z != minZ && z != maxZ - 1 || !this.isVoxelVisible(playerLoc, new Vector3d((double)x, (double)y, (double)z))) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    private boolean isVoxelVisible(Vector3d playerLoc, Vector3d position) {
        Vector3d[] targets = new Vector3d[]{position, position.func_72441_c(0.95, 0.0, 0.0), position.func_72441_c(0.0, 0.95, 0.0), position.func_72441_c(0.95, 0.95, 0.0), position.func_72441_c(0.0, 0.0, 0.95), position.func_72441_c(0.95, 0.0, 0.95), position.func_72441_c(0.0, 0.95, 0.95), position.func_72441_c(0.95, 0.95, 0.95)};
        return this.isVisible(playerLoc, targets);
    }

    public void resetCache() {
        Arrays.fill(this.cache, (byte)0);
    }

    private boolean isVisible(Vector3d start, Vector3d[] targets) {
        Vector3d target;
        int v;
        int maxX = 0;
        int maxY = 0;
        int maxZ = 0;
        for (int i = 0; i < targets.length; ++i) {
            maxX = Math.max(maxX, (int)Math.abs(targets[i].field_72450_a));
            maxY = Math.max(maxY, (int)Math.abs(targets[i].field_72448_b));
            maxZ = Math.max(maxZ, (int)Math.abs(targets[i].field_72449_c));
        }
        if (maxX > 62 || maxY > 62 || maxZ > 62) {
            return false;
        }
        for (v = 0; v < targets.length; ++v) {
            int offset;
            int cz;
            int cy;
            target = targets[v];
            int cx = (int)Math.floor(target.field_72450_a + 64.0);
            int keyPos = cx + (cy = (int)Math.floor(target.field_72448_b + 64.0)) * 128 + (cz = (int)Math.floor(target.field_72449_c + 64.0)) * 128 * 128;
            int entry = keyPos / 4;
            int cVal = this.cache[entry] >> (offset = keyPos % 4 * 2) & 3;
            if (cVal == 2) {
                return false;
            }
            if (cVal != 1) continue;
            return true;
        }
        for (v = 0; v < targets.length; ++v) {
            double t_next_z;
            int z_inc;
            double t_next_y;
            int y_inc;
            double t_next_x;
            int x_inc;
            target = targets[v];
            double x0 = start.func_82615_a();
            double y0 = start.func_82617_b();
            double z0 = start.func_82616_c();
            double x1 = x0 + target.func_82615_a();
            double y1 = y0 + target.func_82617_b();
            double z1 = z0 + target.func_82616_c();
            double dx = Math.abs(x1 - x0);
            double dy = Math.abs(y1 - y0);
            double dz = Math.abs(z1 - z0);
            int x = (int)Math.floor(x0);
            int y = (int)Math.floor(y0);
            int z = (int)Math.floor(z0);
            double dt_dx = 1.0 / dx;
            double dt_dy = 1.0 / dy;
            double dt_dz = 1.0 / dz;
            int n = 1;
            if (dx == 0.0) {
                x_inc = 0;
                t_next_x = dt_dx;
            } else if (x1 > x0) {
                x_inc = 1;
                n += (int)Math.floor(x1) - x;
                t_next_x = (float)((Math.floor(x0) + 1.0 - x0) * dt_dx);
            } else {
                x_inc = -1;
                n += x - (int)Math.floor(x1);
                t_next_x = (float)((x0 - Math.floor(x0)) * dt_dx);
            }
            if (dy == 0.0) {
                y_inc = 0;
                t_next_y = dt_dy;
            } else if (y1 > y0) {
                y_inc = 1;
                n += (int)Math.floor(y1) - y;
                t_next_y = (float)((Math.floor(y0) + 1.0 - y0) * dt_dy);
            } else {
                y_inc = -1;
                n += y - (int)Math.floor(y1);
                t_next_y = (float)((y0 - Math.floor(y0)) * dt_dy);
            }
            if (dz == 0.0) {
                z_inc = 0;
                t_next_z = dt_dz;
            } else if (z1 > z0) {
                z_inc = 1;
                n += (int)Math.floor(z1) - z;
                t_next_z = (float)((Math.floor(z0) + 1.0 - z0) * dt_dz);
            } else {
                z_inc = -1;
                n += z - (int)Math.floor(z1);
                t_next_z = (float)((z0 - Math.floor(z0)) * dt_dz);
            }
            boolean finished = this.stepRay(start, x0, y0, z0, x, y, z, dt_dx, dt_dy, dt_dz, n, x_inc, y_inc, z_inc, t_next_y, t_next_x, t_next_z);
            if (!finished) continue;
            this.cacheResult(targets[0], true);
            return true;
        }
        this.cacheResult(targets[0], false);
        return false;
    }

    private void cacheResult(Vector3d vector, boolean result) {
        int cx = (int)Math.floor(vector.field_72450_a + 64.0);
        int cy = (int)Math.floor(vector.field_72448_b + 64.0);
        int cz = (int)Math.floor(vector.field_72449_c + 64.0);
        int keyPos = cx + cy * 128 + cz * 128 * 128;
        int entry = keyPos / 4;
        int offset = keyPos % 4 * 2;
        if (result) {
            int n = entry;
            this.cache[n] = (byte)(this.cache[n] | 1 << offset);
        } else {
            int n = entry;
            this.cache[n] = (byte)(this.cache[n] | 1 << offset + 1);
        }
    }

    private boolean stepRay(Vector3d start, double x0, double y0, double z0, int x, int y, int z, double dt_dx, double dt_dy, double dt_dz, int n, int x_inc, int y_inc, int z_inc, double t_next_y, double t_next_x, double t_next_z) {
        int chunkX = 0;
        int chunkZ = 0;
        Chunk snapshot = null;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        while (n > 1) {
            int offset;
            int cz;
            int cy;
            int cx = (int)Math.floor(x0 - (double)x + 64.0);
            int keyPos = cx + (cy = (int)Math.floor(y0 - (double)y + 64.0)) * 128 + (cz = (int)Math.floor(z0 - (double)z + 64.0)) * 128 * 128;
            int entry = keyPos / 4;
            int cVal = this.cache[entry] >> (offset = keyPos % 4 * 2) & 3;
            if (cVal == 2) {
                return false;
            }
            if (cVal == 0) {
                int relativeZ;
                int tchunkX = (int)Math.floor((double)x / 16.0);
                int tchunkZ = (int)Math.floor((double)z / 16.0);
                if ((snapshot == null || chunkX != tchunkX || chunkZ != tchunkZ) && (snapshot = world.func_212866_a_(chunkX = tchunkX, chunkZ = tchunkZ)) == null) {
                    return false;
                }
                int relativeX = x % 16;
                if (relativeX < 0) {
                    relativeX = 16 + relativeX;
                }
                if ((relativeZ = z % 16) < 0) {
                    relativeZ = 16 + relativeZ;
                }
                if (relativeX < 0) {
                    int n2 = entry;
                    this.cache[n2] = (byte)(this.cache[n2] | 1 << offset + 1);
                    return false;
                }
                if (relativeZ < 0) {
                    int n3 = entry;
                    this.cache[n3] = (byte)(this.cache[n3] | 1 << offset + 1);
                    return false;
                }
                if (y < 0 || y > 255) {
                    int n4 = entry;
                    this.cache[n4] = (byte)(this.cache[n4] | 1 << offset + 1);
                    return false;
                }
                BlockPos pos = new BlockPos(x, y, z);
                BlockState state = snapshot.func_180495_p(pos);
                if (state.func_200015_d((IBlockReader)world, pos)) {
                    int n5 = entry;
                    this.cache[n5] = (byte)(this.cache[n5] | 1 << offset + 1);
                    return false;
                }
                int n6 = entry;
                this.cache[n6] = (byte)(this.cache[n6] | 1 << offset);
            }
            if (t_next_y < t_next_x && t_next_y < t_next_z) {
                y += y_inc;
                t_next_y += dt_dy;
            } else if (t_next_x < t_next_y && t_next_x < t_next_z) {
                x += x_inc;
                t_next_x += dt_dx;
            } else {
                z += z_inc;
                t_next_z += dt_dz;
            }
            --n;
        }
        return true;
    }
}

