/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client;

import com.google.common.collect.ImmutableList;
import java.util.Random;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.ClientEventHandler;
import me.paulf.fairylights.client.FLClientConfig;
import me.paulf.fairylights.client.command.ClientCommandProvider;
import me.paulf.fairylights.client.command.JinglerCommand;
import me.paulf.fairylights.client.renderer.block.entity.FastenerBlockEntityRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LetterBuntingRenderer;
import me.paulf.fairylights.client.renderer.block.entity.LightBlockEntityRenderer;
import me.paulf.fairylights.client.renderer.block.entity.PennantBuntingRenderer;
import me.paulf.fairylights.client.renderer.entity.FenceFastenerRenderer;
import me.paulf.fairylights.client.tutorial.ClippyController;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.entity.FLEntities;
import me.paulf.fairylights.server.feature.light.ColorChangingBehavior;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public final class ClientProxy
extends ServerProxy {
    public static final Material SOLID_TEXTURE = new Material(AtlasTexture.field_110575_b, new ResourceLocation("fairylights", "entity/connections"));
    public static final Material TRANSLUCENT_TEXTURE = new Material(AtlasTexture.field_110575_b, new ResourceLocation("fairylights", "entity/connections"));
    private final ImmutableList<ResourceLocation> entityModels = new ImmutableList.Builder().addAll(PennantBuntingRenderer.MODELS).addAll((Iterable)LetterBuntingRenderer.MODELS.values()).build();

    @Override
    public void init(IEventBus modBus) {
        super.init(modBus);
        new ClippyController().init(modBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, FLClientConfig.SPEC);
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        new ClientCommandProvider.Builder().add(JinglerCommand::register).build().register(MinecraftForge.EVENT_BUS);
        JinglerCommand.register(MinecraftForge.EVENT_BUS);
        modBus.addListener(e -> {
            if (SOLID_TEXTURE.func_229310_a_().equals((Object)e.getMap().func_229223_g_())) {
                e.addSprite(SOLID_TEXTURE.func_229313_b_());
            }
        });
        modBus.addListener(e -> this.entityModels.forEach(path -> {
            IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(path);
            if (model == Minecraft.func_71410_x().func_209506_al().func_174951_a()) {
                return;
            }
            TextureAtlasSprite sprite = model.getParticleTexture((IModelData)EmptyModelData.INSTANCE);
            int w = (int)((float)sprite.func_94211_a() / (sprite.func_94212_f() - sprite.func_94209_e()));
            int h = (int)((float)sprite.func_94216_b() / (sprite.func_94210_h() - sprite.func_94206_g()));
            for (BakedQuad quad : model.getQuads(null, null, new Random(42L), (IModelData)EmptyModelData.INSTANCE)) {
                int[] data = quad.func_178209_a();
                for (int n = 0; n < 4; ++n) {
                    data[n * 8 + 4] = Float.floatToIntBits((float)Math.round(Float.intBitsToFloat(data[n * 8 + 4]) * (float)w) / (float)w);
                    data[n * 8 + 5] = Float.floatToIntBits((float)Math.round(Float.intBitsToFloat(data[n * 8 + 5]) * (float)h) / (float)h);
                }
            }
        }));
        modBus.addListener(this::setup);
        modBus.addListener(this::setupColors);
    }

    private void setup(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FLBlockEntities.FASTENER.get()), dispatcher -> new FastenerBlockEntityRenderer((TileEntityRendererDispatcher)dispatcher, ServerProxy.buildBlockView()));
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)FLBlockEntities.LIGHT.get()), LightBlockEntityRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)FLEntities.FASTENER.get()), FenceFastenerRenderer::new);
        ModelLoader.addSpecialModel((ResourceLocation)FenceFastenerRenderer.MODEL);
        this.entityModels.forEach(ModelLoader::addSpecialModel);
        RenderTypeLookup.setRenderLayer((Block)((Block)FLBlocks.FASTENER.get()), (RenderType)RenderType.func_228641_d_());
    }

    private void setupColors(ColorHandlerEvent.Item event) {
        if (!FLItems.FAIRY_LIGHT.isPresent() && FairyLights.isForgeInStupidState()) {
            return;
        }
        ItemColors colors = event.getItemColors();
        colors.func_199877_a((stack, index) -> {
            if (index == 1) {
                if (ColorChangingBehavior.exists(stack)) {
                    return ColorChangingBehavior.animate(stack);
                }
                return DyeableItem.getColor(stack);
            }
            return 0xFFFFFF;
        }, new IItemProvider[]{(IItemProvider)FLItems.FAIRY_LIGHT.get(), (IItemProvider)FLItems.PAPER_LANTERN.get(), (IItemProvider)FLItems.ORB_LANTERN.get(), (IItemProvider)FLItems.FLOWER_LIGHT.get(), (IItemProvider)FLItems.CANDLE_LANTERN_LIGHT.get(), (IItemProvider)FLItems.OIL_LANTERN_LIGHT.get(), (IItemProvider)FLItems.JACK_O_LANTERN.get(), (IItemProvider)FLItems.SKULL_LIGHT.get(), (IItemProvider)FLItems.GHOST_LIGHT.get(), (IItemProvider)FLItems.SPIDER_LIGHT.get(), (IItemProvider)FLItems.WITCH_LIGHT.get(), (IItemProvider)FLItems.SNOWFLAKE_LIGHT.get(), (IItemProvider)FLItems.HEART_LIGHT.get(), (IItemProvider)FLItems.MOON_LIGHT.get(), (IItemProvider)FLItems.STAR_LIGHT.get(), (IItemProvider)FLItems.ICICLE_LIGHTS.get(), (IItemProvider)FLItems.METEOR_LIGHT.get()});
        colors.func_199877_a((stack, index) -> {
            ListNBT tagList;
            CompoundNBT tag = stack.func_77978_p();
            if (index == 0) {
                if (tag != null) {
                    return HangingLightsConnectionItem.getString(tag).getColor();
                }
                return ((StringType)StringTypes.BLACK_STRING.get()).getColor();
            }
            if (tag != null && (tagList = tag.func_150295_c("pattern", 10)).size() > 0) {
                ItemStack item = ItemStack.func_199557_a((CompoundNBT)tagList.func_150305_b((index - 1) % tagList.size()));
                if (ColorChangingBehavior.exists(item)) {
                    return ColorChangingBehavior.animate(item);
                }
                return DyeableItem.getColor(item);
            }
            if (FairyLights.CHRISTMAS.isOccurringNow()) {
                return ((long)index + Util.func_211177_b() / 2000L) % 2L == 0L ? 0x993333 : 8375321;
            }
            return 16766340;
        }, new IItemProvider[]{(IItemProvider)FLItems.HANGING_LIGHTS.get()});
        colors.func_199877_a((stack, index) -> index == 0 ? DyeableItem.getColor(stack) : -1, new IItemProvider[]{(IItemProvider)FLItems.TINSEL.get()});
        colors.func_199877_a((stack, index) -> {
            ListNBT tagList;
            if (index == 0) {
                return -1;
            }
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null && (tagList = tag.func_150295_c("pattern", 10)).size() > 0) {
                ItemStack light = ItemStack.func_199557_a((CompoundNBT)tagList.func_150305_b((index - 1) % tagList.size()));
                return DyeableItem.getColor(light);
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)FLItems.PENNANT_BUNTING.get()});
        colors.func_199877_a(ClientProxy::secondLayerColor, new IItemProvider[]{(IItemProvider)FLItems.TRIANGLE_PENNANT.get()});
        colors.func_199877_a(ClientProxy::secondLayerColor, new IItemProvider[]{(IItemProvider)FLItems.SPEARHEAD_PENNANT.get()});
        colors.func_199877_a(ClientProxy::secondLayerColor, new IItemProvider[]{(IItemProvider)FLItems.SWALLOWTAIL_PENNANT.get()});
        colors.func_199877_a(ClientProxy::secondLayerColor, new IItemProvider[]{(IItemProvider)FLItems.SQUARE_PENNANT.get()});
        colors.func_199877_a((stack, index) -> {
            StyledString str;
            CompoundNBT tag = stack.func_77978_p();
            if (index > 0 && tag != null && (str = StyledString.deserialize(tag.func_74775_l("text"))).length() > 0) {
                TextFormatting lastColor = null;
                TextFormatting color = null;
                int n = (index - 1) % str.length();
                for (int i = 0; i < str.length() && (lastColor == (color = str.styleAt(i).getColor()) || n-- != 0); ++i) {
                    lastColor = color;
                }
                return StyledString.getColor(color) | 0xFF000000;
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)FLItems.LETTER_BUNTING.get()});
    }

    private static int secondLayerColor(ItemStack stack, int index) {
        return index == 0 ? 0xFFFFFF : DyeableItem.getColor(stack);
    }
}

