/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui;

import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.client.gui.component.PaletteButton;
import me.paulf.fairylights.client.gui.component.StyledTextFieldWidget;
import me.paulf.fairylights.client.gui.component.ToggleButton;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.serverbound.EditLetteredConnectionMessage;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public final class EditLetteredConnectionScreen<C extends Connection>
extends Screen {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("fairylights", "textures/gui/widgets.png");
    private final C connection;
    private StyledTextFieldWidget textField;
    private Button doneBtn;
    private Button cancelBtn;
    private ColorButton colorBtn;
    private ToggleButton boldBtn;
    private ToggleButton italicBtn;
    private ToggleButton underlineBtn;
    private ToggleButton strikethroughBtn;
    private PaletteButton paletteBtn;

    public EditLetteredConnectionScreen(C connection) {
        super(NarratorChatListener.field_216868_a);
        this.connection = connection;
    }

    public void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        int pad = 4;
        int buttonWidth = 150;
        this.doneBtn = (Button)this.addButton((Widget)new Button(this.width / 2 - 4 - 150, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), b -> {
            FairyLights.NETWORK.sendToServer(new EditLetteredConnectionMessage<C>(this.connection, this.textField.getValue()));
            this.onClose();
        }));
        this.cancelBtn = (Button)this.addButton((Widget)new Button(this.width / 2 + 4, this.height / 4 + 120 + 12, 150, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), b -> this.onClose()));
        int textFieldX = this.width / 2 - 150;
        int textFieldY = this.height / 2 - 10;
        int buttonX = textFieldX;
        int buttonY = textFieldY - 25;
        int bInc = 24;
        this.colorBtn = (ColorButton)this.addButton((Widget)new ColorButton(buttonX, buttonY, "", b -> {
            this.paletteBtn.visible = !this.paletteBtn.visible;
        }));
        this.paletteBtn = (PaletteButton)this.addButton((Widget)new PaletteButton(buttonX - 4, buttonY - 30, this.colorBtn, "fairylights.color", b -> this.textField.updateStyling(this.colorBtn.getDisplayColor(), true)));
        this.boldBtn = (ToggleButton)this.addButton((Widget)new ToggleButton(buttonX += 24, buttonY, 40, 0, "", b -> this.updateStyleButton(TextFormatting.BOLD, this.boldBtn)));
        this.italicBtn = (ToggleButton)this.addButton((Widget)new ToggleButton(buttonX += 24, buttonY, 60, 0, "", b -> this.updateStyleButton(TextFormatting.ITALIC, this.italicBtn)));
        this.underlineBtn = (ToggleButton)this.addButton((Widget)new ToggleButton(buttonX += 24, buttonY, 80, 0, "", b -> this.updateStyleButton(TextFormatting.UNDERLINE, this.underlineBtn)));
        this.strikethroughBtn = (ToggleButton)this.addButton((Widget)new ToggleButton(buttonX += 24, buttonY, 100, 0, "", b -> this.updateStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn)));
        this.textField = new StyledTextFieldWidget(this.font, this.colorBtn, this.boldBtn, this.italicBtn, this.underlineBtn, this.strikethroughBtn, textFieldX, textFieldY, 300, 20, "fairylights.letteredText");
        this.textField.setValue(((Lettered)this.connection).getText());
        this.textField.setCaretStart();
        this.textField.setIsBlurable(false);
        this.textField.registerChangeListener(this::validateText);
        this.textField.setCharInputTransformer(((Lettered)this.connection).getInputTransformer());
        this.textField.setFocused(true);
        this.children.add(this.textField);
        this.paletteBtn.visible = false;
        StylingPresence ss = ((Lettered)this.connection).getSupportedStyling();
        this.colorBtn.visible = ss.hasColor();
        this.boldBtn.visible = ss.hasBold();
        this.italicBtn.visible = ss.hasItalic();
        this.underlineBtn.visible = ss.hasUnderline();
        this.strikethroughBtn.visible = ss.hasStrikethrough();
        this.setFocused(this.textField);
    }

    private void validateText(StyledString text) {
        this.doneBtn.active = ((Lettered)this.connection).isSupportedText(text) && !((Lettered)this.connection).getText().equals(text);
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        int x = (int)(mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
        int y = (int)(mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
        this.textField.update(x, y);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.paletteBtn.visible = false;
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 66)) {
            this.toggleStyleButton(TextFormatting.BOLD, this.boldBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 73)) {
            this.toggleStyleButton(TextFormatting.ITALIC, this.italicBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 85)) {
            this.toggleStyleButton(TextFormatting.UNDERLINE, this.underlineBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 83)) {
            this.toggleStyleButton(TextFormatting.STRIKETHROUGH, this.strikethroughBtn);
            return true;
        }
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.doneBtn.active) {
            this.doneBtn.onPress();
            return true;
        }
        if (keyCode == 256) {
            this.cancelBtn.onPress();
            return true;
        }
        return false;
    }

    private void toggleStyleButton(TextFormatting styling, ToggleButton btn) {
        btn.setValue(!btn.getValue());
        this.updateStyleButton(styling, btn);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        this.paletteBtn.visible = false;
        return false;
    }

    private void updateStyleButton(TextFormatting styling, ToggleButton btn) {
        if (btn.visible) {
            this.textField.updateStyling(styling, btn.getValue());
        }
    }

    public void render(int mouseX, int mouseY, float delta) {
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"fairylights.editLetteredConnection", (Object[])new Object[0]), this.width / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, delta);
        this.textField.render(mouseX, mouseY, delta);
        String allowed = ((Lettered)this.connection).getAllowedDescription();
        if (!allowed.isEmpty()) {
            this.drawString(this.font, new TranslationTextComponent("fairylights.editLetteredConnection.allowed_characters", new Object[]{allowed}).func_211708_a(TextFormatting.GRAY).func_150254_d(), this.textField.x, this.textField.y + this.textField.getHeight() + 4, -1);
        }
    }

    public static boolean isControlOp(int key, int controlKey) {
        return key == controlKey && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }
}

