/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.midi;

import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.util.Mth;
import net.minecraft.client.Minecraft;

public final class MidiJingler
implements Receiver {
    private HangingLightsConnection connection;

    public MidiJingler(HangingLightsConnection connection) {
        this.connection = connection;
    }

    public HangingLightsConnection getConnection() {
        return this.connection;
    }

    @Override
    public void send(MidiMessage msg, long timestamp) {
        Light[] lights;
        int offset;
        if (this.connection == null) {
            return;
        }
        if (!(msg instanceof ShortMessage)) {
            return;
        }
        ShortMessage shortMsg = (ShortMessage)msg;
        if (shortMsg.getCommand() != 144 || shortMsg.getData2() == 0) {
            return;
        }
        int inMCSpace = shortMsg.getData1() - 53;
        int note = inMCSpace == 24 ? 24 : Mth.mod(inMCSpace, 24);
        int idx = note + (offset = (lights = (Light[])this.connection.getFeatures()).length / 2 - 12);
        if (idx >= 0 && idx < lights.length) {
            Minecraft.func_71410_x().execute(() -> lights[idx].jingle(this.connection.getWorld(), this.connection.getFastener().getConnectionPoint(), note));
        }
    }

    @Override
    public void close() {
        this.connection = null;
    }
}

