/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.util.Catenary;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public abstract class ConnectionRenderer<C extends Connection> {
    private final WireModel model;

    protected ConnectionRenderer(int wireU, int wireV, float wireSize) {
        this.model = new WireModel(wireU, wireV, wireSize);
    }

    public void render(C conn, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        Catenary currCat = ((Connection)conn).getCatenary();
        Catenary prevCat = ((Connection)conn).getPrevCatenary();
        if (currCat != null && prevCat != null) {
            Catenary cat = prevCat.lerp(currCat, delta);
            Catenary.SegmentIterator it = cat.iterator();
            IVertexBuilder buf = ClientProxy.SOLID_TEXTURE.func_229311_a_(source, RenderType::func_228638_b_);
            int color = this.getWireColor(conn);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            while (it.next()) {
                this.model.root.field_78800_c = it.getX(0.0f) * 16.0f;
                this.model.root.field_78797_d = it.getY(0.0f) * 16.0f;
                this.model.root.field_78798_e = it.getZ(0.0f) * 16.0f;
                this.model.root.field_78796_g = 1.5707964f - it.getYaw();
                this.model.root.field_78795_f = -it.getPitch();
                this.model.root.field_78808_h = 0.0f;
                this.model.length = it.getLength() * 16.0f;
                this.model.func_225598_a_(matrix, buf, packedLight, packedOverlay, r, g, b, 1.0f);
                this.renderSegment(conn, it, delta, matrix, source, packedLight, packedOverlay);
            }
            this.render(conn, cat, delta, matrix, source, packedLight, packedOverlay);
        }
    }

    protected int getWireColor(C conn) {
        return 0xFFFFFF;
    }

    protected void render(C conn, Catenary catenary, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
    }

    protected void renderSegment(C connection, Catenary.SegmentView it, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
    }

    private static class WireModel
    extends Model {
        final ModelRenderer root;
        float length;

        WireModel(int u, int v, final float size) {
            super(RenderType::func_228638_b_);
            this.field_78090_t = 128;
            this.field_78089_u = 128;
            this.root = new ModelRenderer(this, u, v){

                public void func_228307_a_(MatrixStack stack) {
                    super.func_228307_a_(stack);
                    stack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_226593_a_((float)(1.0f + size % 1.0f), (float)1.0f, (float)length));
                }
            };
            int s = MathHelper.func_76141_d((float)size);
            this.root.func_228300_a_((float)(-s) * 0.5f, (float)(-s) * 0.5f, 0.0f, (float)s, (float)s, 1.0f);
        }

        public void func_225598_a_(MatrixStack matrix, IVertexBuilder builder, int light, int overlay, float r, float g, float b, float a) {
            this.root.func_228309_a_(matrix, builder, light, overlay, r, g, b, a);
        }
    }
}

