/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import me.paulf.fairylights.client.renderer.block.entity.ConnectionRenderer;
import me.paulf.fairylights.client.renderer.block.entity.FastenerRenderer;
import me.paulf.fairylights.server.connection.PennantBuntingConnection;
import me.paulf.fairylights.server.feature.Pennant;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.styledstring.Style;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class PennantBuntingRenderer
extends ConnectionRenderer<PennantBuntingConnection> {
    private static final ResourceLocation TRIANGLE_MODEL = new ResourceLocation("fairylights", "entity/triangle_pennant");
    private static final ResourceLocation SPEARHEAD_MODEL = new ResourceLocation("fairylights", "entity/spearhead_pennant");
    private static final ResourceLocation SWALLOWTAIL_MODEl = new ResourceLocation("fairylights", "entity/swallowtail_pennant");
    private static final ResourceLocation SQUARE_MODEL = new ResourceLocation("fairylights", "entity/square_pennant");
    public static final ImmutableSet<ResourceLocation> MODELS = ImmutableSet.of((Object)TRIANGLE_MODEL, (Object)SPEARHEAD_MODEL, (Object)SWALLOWTAIL_MODEl, (Object)SQUARE_MODEL);
    private final ImmutableMap<Item, ResourceLocation> models = ImmutableMap.of((Object)FLItems.TRIANGLE_PENNANT.get(), (Object)TRIANGLE_MODEL, (Object)FLItems.SPEARHEAD_PENNANT.get(), (Object)SPEARHEAD_MODEL, (Object)FLItems.SWALLOWTAIL_PENNANT.get(), (Object)SWALLOWTAIL_MODEl, (Object)FLItems.SQUARE_PENNANT.get(), (Object)SQUARE_MODEL);

    public PennantBuntingRenderer() {
        super(0, 17, 1.25f);
    }

    @Override
    protected void render(PennantBuntingConnection conn, Catenary catenary, float delta, MatrixStack matrix, IRenderTypeBuffer source, int packedLight, int packedOverlay) {
        super.render(conn, catenary, delta, matrix, source, packedLight, packedOverlay);
        Pennant[] currLights = (Pennant[])conn.getFeatures();
        if (currLights != null) {
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            IVertexBuilder buf = source.getBuffer(Atlases.func_228783_h_());
            int count = currLights.length;
            if (count == 0) {
                return;
            }
            StyledString text = conn.getText();
            if (text.length() > count) {
                text = text.substring(0, count);
            }
            int offset = (count - text.length()) / 2;
            for (int i = 0; i < count; ++i) {
                Pennant currPennant = currLights[i];
                int color = currPennant.getColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel((ResourceLocation)this.models.getOrDefault((Object)currPennant.getItem(), (Object)TRIANGLE_MODEL));
                Vec3d pos = currPennant.getPoint(delta);
                matrix.func_227860_a_();
                matrix.func_227861_a_(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-currPennant.getYaw(delta)));
                matrix.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(currPennant.getPitch(delta)));
                matrix.func_227863_a_(Vector3f.field_229179_b_.func_229193_c_(currPennant.getRoll(delta)));
                matrix.func_227860_a_();
                FastenerRenderer.renderBakedModel(model, matrix, buf, r, g, b, packedLight, packedOverlay);
                matrix.func_227865_b_();
                if (i >= offset && i < offset + text.length()) {
                    this.drawLetter(matrix, source, currPennant, packedLight, font, text, i - offset, 1, delta);
                    this.drawLetter(matrix, source, currPennant, packedLight, font, text, text.length() - 1 - (i - offset), -1, delta);
                }
                matrix.func_227865_b_();
            }
        }
    }

    private void drawLetter(MatrixStack matrix, IRenderTypeBuffer source, Pennant pennant, int packedLight, FontRenderer font, StyledString text, int index, int side, float delta) {
        Style style = text.styleAt(index);
        StringBuilder bob = new StringBuilder();
        if (style.isObfuscated()) {
            bob.append(TextFormatting.OBFUSCATED);
        }
        if (style.isBold()) {
            bob.append(TextFormatting.BOLD);
        }
        if (style.isStrikethrough()) {
            bob.append(TextFormatting.STRIKETHROUGH);
        }
        if (style.isUnderline()) {
            bob.append(TextFormatting.UNDERLINE);
        }
        if (style.isItalic()) {
            bob.append(TextFormatting.ITALIC);
        }
        bob.append(text.charAt(index));
        String chr = bob.toString();
        Matrix3f m = new Matrix3f();
        m.func_226119_c_();
        m.func_226115_a_(Vector3f.field_229181_d_.func_229193_c_(pennant.getYaw(delta)));
        m.func_226115_a_(Vector3f.field_229183_f_.func_229193_c_(pennant.getPitch(delta)));
        m.func_226115_a_(Vector3f.field_229179_b_.func_229193_c_(pennant.getRoll(delta)));
        Vector3f v = new Vector3f(0.0f, 0.0f, (float)side);
        v.func_229188_a_(m);
        float brightness = LightUtil.diffuseLight((float)v.func_195899_a(), (float)v.func_195900_b(), (float)v.func_195902_c());
        int styleColor = (Integer)MoreObjects.firstNonNull((Object)style.getColor().func_211163_e(), (Object)0xFFFFFF);
        int r = (int)((float)(styleColor >> 16 & 0xFF) * brightness);
        int g = (int)((float)(styleColor >> 8 & 0xFF) * brightness);
        int b = (int)((float)(styleColor & 0xFF) * brightness);
        int argb = 0xFF000000 | r << 16 | g << 8 | b;
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.0, -0.25, (double)(0.04f * (float)side));
        float s = 0.03075f;
        matrix.func_227862_a_(0.03075f * (float)side, -0.03075f, 0.03075f);
        float w = font.func_78256_a(chr);
        font.func_228079_a_(chr, -(w - 1.0f) / 2.0f, -4.0f, argb, false, matrix.func_227866_c_().func_227870_a_(), source, false, 0, packedLight);
        matrix.func_227865_b_();
    }
}

