/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.paulf.fairylights.data.GenericRecipeBuilder;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraftforge.common.Tags;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="fairylights", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class DataGatherer {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.func_200390_a((IDataProvider)new RecipeGenerator(gen));
        gen.func_200390_a((IDataProvider)new LootTableGenerator(gen));
    }

    static Consumer<IFinishedRecipe> addNbt(Consumer<IFinishedRecipe> consumer, CompoundNBT nbt) {
        return recipe -> consumer.accept(new ForwardingFinishedRecipe((IFinishedRecipe)recipe, nbt){
            final /* synthetic */ IFinishedRecipe val$recipe;
            final /* synthetic */ CompoundNBT val$nbt;
            {
                this.val$recipe = iFinishedRecipe;
                this.val$nbt = compoundNBT;
            }

            @Override
            protected IFinishedRecipe delegate() {
                return this.val$recipe;
            }

            @Override
            public void func_218610_a(JsonObject json) {
                super.func_218610_a(json);
                json.getAsJsonObject("result").addProperty("nbt", this.val$nbt.toString());
            }
        });
    }

    static abstract class ForwardingFinishedRecipe
    implements IFinishedRecipe {
        ForwardingFinishedRecipe() {
        }

        protected abstract IFinishedRecipe delegate();

        public void func_218610_a(JsonObject json) {
            this.delegate().func_218610_a(json);
        }

        public ResourceLocation func_200442_b() {
            return this.delegate().func_200442_b();
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.delegate().func_218609_c();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.delegate().func_200440_c();
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.delegate().func_200443_d();
        }
    }

    static class BlockLootTableGenerator
    extends BlockLootTables {
        BlockLootTableGenerator() {
        }

        protected Iterable<Block> getKnownBlocks() {
            return FLBlocks.REG.getEntries().stream().map(RegistryObject::get).collect(Collectors.toList());
        }

        protected void addTables() {
        }
    }

    static class LootTableGenerator
    extends LootTableProvider {
        LootTableGenerator(DataGenerator generator) {
            super(generator);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(BlockLootTableGenerator::new, (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker tracker) {
            map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)tracker, (ResourceLocation)name, (LootTable)table));
        }
    }

    static class RecipeGenerator
    extends RecipeProvider {
        RecipeGenerator(DataGenerator generator) {
            super(generator);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("text", (INBT)StyledString.serialize(new StyledString()));
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)FLItems.LETTER_BUNTING.get())).func_200472_a("I-I").func_200472_a("PBF").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('-'), Tags.Items.STRING).func_200462_a(Character.valueOf('P'), (IItemProvider)Items.field_151121_aF).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_196136_br).func_200469_a(Character.valueOf('F'), Tags.Items.FEATHERS).func_200465_a("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).func_200465_a("has_string", (ICriterionInstance)this.func_200409_a(Tags.Items.STRING)).func_200464_a(DataGatherer.addNbt(consumer, nbt));
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)FLItems.GARLAND.get()), (int)2).func_200472_a("I-I").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('-'), (IItemProvider)Items.field_221796_dh).func_200465_a("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).func_200465_a("has_vine", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221796_dh)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)FLItems.OIL_LANTERN.get()), (int)4).func_200472_a(" I ").func_200472_a("STS").func_200472_a("IGI").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('S'), (IItemProvider)Items.field_151055_y).func_200462_a(Character.valueOf('T'), (IItemProvider)Items.field_221657_bQ).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).func_200465_a("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).func_200465_a("has_torch", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221657_bQ)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)FLItems.CANDLE_LANTERN.get()), (int)4).func_200472_a(" I ").func_200472_a("GTG").func_200472_a("IGI").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.NUGGETS_GOLD).func_200462_a(Character.valueOf('T'), (IItemProvider)Items.field_221657_bQ).func_200465_a("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).func_200465_a("has_torch", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221657_bQ)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)FLItems.INCANDESCENT_LIGHT.get()), (int)4).func_200472_a(" I ").func_200472_a("ITI").func_200472_a(" G ").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('G'), Tags.Items.GLASS_PANES_COLORLESS).func_200462_a(Character.valueOf('T'), (IItemProvider)Items.field_221657_bQ).func_200465_a("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).func_200465_a("has_torch", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_221657_bQ)).func_200464_a(consumer);
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS.get()).addCriterion("has_lights", (ICriterionInstance)this.func_200409_a(FLCraftingRecipes.LIGHTS)).build(consumer, new ResourceLocation("fairylights", "hanging_lights"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.HANGING_LIGHTS_AUGMENTATION.get()).build(consumer, new ResourceLocation("fairylights", "hanging_lights_augmentation"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.TINSEL_GARLAND.get()).addCriterion("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).addCriterion("has_string", (ICriterionInstance)this.func_200409_a(Tags.Items.STRING)).build(consumer, new ResourceLocation("fairylights", "tinsel_garland"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING.get()).addCriterion("has_pennants", (ICriterionInstance)this.func_200409_a(FLCraftingRecipes.PENNANTS)).build(consumer, new ResourceLocation("fairylights", "pennant_bunting"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.PENNANT_BUNTING_AUGMENTATION.get()).build(consumer, new ResourceLocation("fairylights", "pennant_bunting_augmentation"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.EDIT_COLOR.get()).build(consumer, new ResourceLocation("fairylights", "edit_color"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.COPY_COLOR.get()).build(consumer, new ResourceLocation("fairylights", "copy_color"));
            this.pennantRecipe((IRecipeSerializer)FLCraftingRecipes.TRIANGLE_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "triangle_pennant"));
            this.pennantRecipe((IRecipeSerializer)FLCraftingRecipes.SPEARHEAD_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "spearhead_pennant"));
            this.pennantRecipe((IRecipeSerializer)FLCraftingRecipes.SWALLOWTAIL_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "swallowtail_pennant"));
            this.pennantRecipe((IRecipeSerializer)FLCraftingRecipes.SQUARE_PENNANT.get()).build(consumer, new ResourceLocation("fairylights", "square_pennant"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.FAIRY_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "fairy_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.PAPER_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "paper_lantern"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.ORB_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "orb_lantern"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.FLOWER_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "flower_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.CANDLE_LANTERN_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "candle_lantern_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.OIL_LANTERN_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "oil_lantern_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.JACK_O_LANTERN.get()).build(consumer, new ResourceLocation("fairylights", "jack_o_lantern"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.SKULL_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "skull_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.GHOST_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "ghost_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.SPIDER_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "spider_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.WITCH_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "witch_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.SNOWFLAKE_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "snowflake_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.HEART_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "heart_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.MOON_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "moon_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.STAR_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "star_light"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.ICICLE_LIGHTS.get()).build(consumer, new ResourceLocation("fairylights", "icicle_lights"));
            this.lightRecipe((IRecipeSerializer)FLCraftingRecipes.METEOR_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "meteor_light"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.LIGHT_TWINKLE.get()).build(consumer, new ResourceLocation("fairylights", "light_twinkle"));
            GenericRecipeBuilder.customRecipe((IRecipeSerializer)FLCraftingRecipes.COLOR_CHANGING_LIGHT.get()).build(consumer, new ResourceLocation("fairylights", "color_changing_light"));
        }

        GenericRecipeBuilder lightRecipe(IRecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).addCriterion("has_iron", (ICriterionInstance)this.func_200409_a(Tags.Items.INGOTS_IRON)).addCriterion("has_dye", (ICriterionInstance)this.func_200409_a(Tags.Items.DYES));
        }

        GenericRecipeBuilder pennantRecipe(IRecipeSerializer<?> serializer) {
            return GenericRecipeBuilder.customRecipe(serializer).addCriterion("has_paper", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151121_aF)).addCriterion("has_string", (ICriterionInstance)this.func_200409_a(Tags.Items.STRING));
        }
    }
}

