/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import me.paulf.fairylights.util.AABBBuilder;
import me.paulf.fairylights.util.Catenary;
import me.paulf.fairylights.util.RegistryObjects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public abstract class AbstractFastener<F extends FastenerAccessor>
implements Fastener<F> {
    private final Map<UUID, Connection> outgoing = new HashMap<UUID, Connection>();
    private final Map<UUID, Incoming> incoming = new HashMap<UUID, Incoming>();
    protected AxisAlignedBB bounds = TileEntity.INFINITE_EXTENT_AABB;
    @Nullable
    private World world;
    private boolean dirty;
    private final LazyOptional<Fastener<?>> lazyOptional = LazyOptional.of(() -> this);

    @Override
    public Optional<Connection> get(UUID id) {
        return Optional.ofNullable(this.outgoing.get(id));
    }

    @Override
    public List<Connection> getOwnConnections() {
        return ImmutableList.copyOf(this.outgoing.values());
    }

    @Override
    public List<Connection> getAllConnections() {
        ImmutableList.Builder list = new ImmutableList.Builder();
        list.addAll(this.outgoing.values());
        if (this.world != null) {
            this.incoming.values().forEach(i -> i.get(this.world).ifPresent(arg_0 -> ((ImmutableList.Builder)list).add(arg_0)));
        }
        return list.build();
    }

    @Override
    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    @Override
    public abstract BlockPos getPos();

    @Override
    public void setWorld(World world) {
        this.world = world;
        this.outgoing.values().forEach(c -> c.setWorld(world));
    }

    @Override
    @Nullable
    public World getWorld() {
        return this.world;
    }

    @Override
    public boolean update() {
        Iterator<Connection> it = this.outgoing.values().iterator();
        Vec3d fromOffset = this.getConnectionPoint();
        boolean dirty = this.dirty;
        this.dirty = false;
        while (it.hasNext()) {
            Connection connection = it.next();
            if (connection.update(fromOffset)) {
                dirty = true;
            }
            if (!connection.isRemoved()) continue;
            dirty = true;
            it.remove();
            this.incoming.remove(connection.getUUID());
            if (this.world == null) continue;
            this.drop(this.world, this.getPos(), connection);
        }
        if (this.world != null) {
            this.incoming.values().removeIf(incoming -> incoming.gone(this.world));
        }
        if (dirty) {
            this.calculateBoundingBox();
        }
        return dirty;
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    protected void calculateBoundingBox() {
        if (this.outgoing.isEmpty()) {
            this.bounds = new AxisAlignedBB(this.getPos());
            return;
        }
        AABBBuilder builder = new AABBBuilder();
        for (Connection connection : this.outgoing.values()) {
            Catenary catenary = connection.getCatenary();
            if (catenary == null) continue;
            Catenary.SegmentIterator it = catenary.iterator();
            while (it.next()) {
                builder.include(it.getX(0.0f), it.getY(0.0f), it.getZ(0.0f));
                if (it.hasNext()) continue;
                builder.include(it.getX(1.0f), it.getY(1.0f), it.getZ(1.0f));
            }
        }
        this.bounds = builder.add(this.getConnectionPoint()).build();
    }

    @Override
    public void dropItems(World world, BlockPos pos) {
        for (Connection connection : this.getAllConnections()) {
            this.drop(world, pos, connection);
        }
    }

    private void drop(World world, BlockPos pos, Connection connection) {
        if (!connection.shouldDrop()) {
            return;
        }
        float offsetX = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetY = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float offsetZ = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        ItemStack stack = connection.getItemStack();
        ItemEntity entityItem = new ItemEntity(world, (double)((float)pos.func_177958_n() + offsetX), (double)((float)pos.func_177956_o() + offsetY), (double)((float)pos.func_177952_p() + offsetZ), stack);
        float scale = 0.05f;
        entityItem.func_213293_j(world.field_73012_v.nextGaussian() * (double)0.05f, world.field_73012_v.nextGaussian() * (double)0.05f + (double)0.2f, world.field_73012_v.nextGaussian() * (double)0.05f);
        world.func_217376_c((Entity)entityItem);
        connection.noDrop();
    }

    @Override
    public void remove() {
        this.outgoing.values().forEach(Connection::remove);
    }

    @Override
    public boolean hasNoConnections() {
        return this.outgoing.isEmpty() && this.incoming.isEmpty();
    }

    @Override
    public boolean hasConnectionWith(Fastener<?> fastener) {
        return this.getConnectionTo((FastenerAccessor)fastener.createAccessor()) != null;
    }

    @Override
    @Nullable
    public Connection getConnectionTo(FastenerAccessor destination) {
        for (Connection connection : this.outgoing.values()) {
            if (!connection.isDestination(destination)) continue;
            return connection;
        }
        return null;
    }

    @Override
    public boolean removeConnection(UUID uuid) {
        Connection connection = this.outgoing.remove(uuid);
        if (connection != null) {
            connection.remove();
            this.setDirty();
            return true;
        }
        if (this.incoming.remove(uuid) != null) {
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeConnection(Connection connection) {
        return this.removeConnection(connection.getUUID());
    }

    @Override
    public boolean reconnect(World world, Connection connection, Fastener<?> newDestination) {
        if (this.equals(newDestination) || newDestination.hasConnectionWith(this)) {
            return false;
        }
        UUID uuid = connection.getUUID();
        if (connection.getDestination().get(world, false).filter(t -> {
            t.removeConnection(uuid);
            return true;
        }).isPresent()) {
            connection.setDestination(newDestination);
            connection.setDrop();
            newDestination.createIncomingConnection(this.world, uuid, this, connection.getType());
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public Connection connect(World world, Fastener<?> destination, ConnectionType<?> type, CompoundNBT compound, boolean drop) {
        UUID uuid = MathHelper.func_188210_a();
        Connection connection = this.createOutgoingConnection(world, uuid, destination, type, compound, drop);
        destination.createIncomingConnection(world, uuid, this, type);
        return connection;
    }

    @Override
    public Connection createOutgoingConnection(World world, UUID uuid, Fastener<?> destination, ConnectionType<?> type, CompoundNBT compound, boolean drop) {
        Object c = type.create(world, this, uuid);
        ((Connection)c).deserialize(destination, compound, drop);
        this.outgoing.put(uuid, (Connection)c);
        this.setDirty();
        return c;
    }

    @Override
    public void createIncomingConnection(World world, UUID uuid, Fastener<?> destination, ConnectionType<?> type) {
        this.incoming.put(uuid, new Incoming((FastenerAccessor)destination.createAccessor(), uuid));
        this.setDirty();
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        ListNBT outgoing = new ListNBT();
        for (Map.Entry<UUID, Connection> connectionEntry : this.outgoing.entrySet()) {
            UUID uuid = connectionEntry.getKey();
            Connection connection = connectionEntry.getValue();
            CompoundNBT connectionCompound = new CompoundNBT();
            connectionCompound.func_218657_a("connection", (INBT)connection.serialize());
            connectionCompound.func_74778_a("type", RegistryObjects.getName(connection.getType()).toString());
            connectionCompound.func_186854_a("uuid", uuid);
            outgoing.add((Object)connectionCompound);
        }
        compound.func_218657_a("outgoing", (INBT)outgoing);
        ListNBT incoming = new ListNBT();
        for (Map.Entry<UUID, Incoming> e : this.incoming.entrySet()) {
            CompoundNBT tag = new CompoundNBT();
            tag.func_186854_a("uuid", e.getKey());
            tag.func_218657_a("fastener", (INBT)FastenerType.serialize(e.getValue().fastener));
            incoming.add((Object)tag);
        }
        compound.func_218657_a("incoming", (INBT)incoming);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        ListNBT listConnections = compound.func_150295_c("outgoing", 10);
        ArrayList<UUID> nbtUUIDs = new ArrayList<UUID>();
        for (int i = 0; i < listConnections.size(); ++i) {
            CompoundNBT connectionCompound = listConnections.func_150305_b(i);
            UUID uuid = connectionCompound.func_186855_b("uuid") ? connectionCompound.func_186857_a("uuid") : MathHelper.func_188210_a();
            nbtUUIDs.add(uuid);
            if (this.outgoing.containsKey(uuid)) {
                Connection connection = this.outgoing.get(uuid);
                connection.deserialize(connectionCompound.func_74775_l("connection"));
                continue;
            }
            ConnectionType type = (ConnectionType)FairyLights.CONNECTION_TYPES.getValue(ResourceLocation.func_208304_a((String)connectionCompound.func_74779_i("type")));
            if (type == null) continue;
            Object connection = type.create(this.world, this, uuid);
            ((Connection)connection).deserialize(connectionCompound.func_74775_l("connection"));
            this.outgoing.put(uuid, (Connection)connection);
        }
        Iterator<Map.Entry<UUID, Connection>> connectionsIter = this.outgoing.entrySet().iterator();
        while (connectionsIter.hasNext()) {
            Map.Entry<UUID, Connection> connection = connectionsIter.next();
            if (nbtUUIDs.contains(connection.getKey())) continue;
            connectionsIter.remove();
            connection.getValue().remove();
        }
        this.incoming.clear();
        ListNBT incoming = compound.func_150295_c("incoming", 10);
        for (int i = 0; i < incoming.size(); ++i) {
            CompoundNBT incomingNbt = incoming.func_150305_b(i);
            UUID uuid = incomingNbt.func_186857_a("uuid");
            FastenerAccessor fastener = FastenerType.deserialize(incomingNbt.func_74775_l("fastener"));
            this.incoming.put(uuid, new Incoming(fastener, uuid));
        }
        this.setDirty();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        return capability == CapabilityHandler.FASTENER_CAP ? this.lazyOptional.cast() : LazyOptional.empty();
    }

    static class Incoming {
        final FastenerAccessor fastener;
        final UUID id;

        Incoming(FastenerAccessor fastener, UUID id) {
            this.fastener = fastener;
            this.id = id;
        }

        boolean gone(World world) {
            return this.fastener.isGone(world);
        }

        Optional<Connection> get(World world) {
            return ((Optional)this.fastener.get(world, false).map(Optional::of).orElse(Optional.empty())).flatMap(f -> f.get(this.id));
        }
    }
}

