/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.fastener.accessor;

import javax.annotation.Nullable;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.fastener.accessor.FastenerAccessor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public final class BlockFastenerAccessor
implements FastenerAccessor {
    private BlockPos pos = BlockPos.field_177992_a;

    public BlockFastenerAccessor() {
    }

    public BlockFastenerAccessor(BlockFastener fastener) {
        this(fastener.getPos());
    }

    public BlockFastenerAccessor(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public LazyOptional<Fastener<?>> get(World world, boolean load) {
        TileEntity entity;
        if ((load || world.func_195588_v(this.pos)) && (entity = world.func_175625_s(this.pos)) != null) {
            return entity.getCapability(CapabilityHandler.FASTENER_CAP);
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean isGone(World world) {
        if (world.field_72995_K || !world.func_195588_v(this.pos)) {
            return false;
        }
        TileEntity entity = world.func_175625_s(this.pos);
        return entity == null || !entity.getCapability(CapabilityHandler.FASTENER_CAP).isPresent();
    }

    @Override
    public FastenerType getType() {
        return FastenerType.BLOCK;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BlockFastenerAccessor) {
            return this.pos.equals((Object)((BlockFastenerAccessor)obj).pos);
        }
        return false;
    }

    @Override
    public CompoundNBT serialize() {
        return NBTUtil.func_186859_a((BlockPos)this.pos);
    }

    @Override
    public void deserialize(CompoundNBT nbt) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt);
    }
}

