/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.ColorLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.StandardLightBehavior;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class CompositeBehavior
implements StandardLightBehavior {
    private final BrightnessLightBehavior brightness;
    private final ColorLightBehavior color;

    public CompositeBehavior(BrightnessLightBehavior brightness, ColorLightBehavior color) {
        this.brightness = brightness;
        this.color = color;
    }

    @Override
    public float getBrightness(float delta) {
        return this.brightness.getBrightness(delta);
    }

    @Override
    public float getRed(float delta) {
        return this.color.getRed(delta);
    }

    @Override
    public float getGreen(float delta) {
        return this.color.getGreen(delta);
    }

    @Override
    public float getBlue(float delta) {
        return this.color.getBlue(delta);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.brightness.power(powered, now, light);
        this.color.power(powered, now, light);
    }

    @Override
    public void tick(World world, Vec3d origin, Light<?> light) {
        this.brightness.tick(world, origin, light);
        this.color.tick(world, origin, light);
    }
}

