/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.BrightnessLightBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class IncandescentBehavior
implements BrightnessLightBehavior {
    private float prevBrightness = 1.0f;
    private float brightness = 1.0f;
    private boolean powered = true;

    @Override
    public float getBrightness(float delta) {
        return MathHelper.func_219799_g((float)delta, (float)this.prevBrightness, (float)this.brightness);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
        if (now) {
            this.brightness = this.powered ? 1.0f : 0.0f;
            this.prevBrightness = this.brightness;
        }
    }

    @Override
    public void tick(World world, Vec3d origin, Light<?> light) {
        this.prevBrightness = this.brightness;
        if (this.powered) {
            this.brighten(1.0f, 0.2f);
        } else {
            this.brighten(0.0f, 0.1f);
        }
        if (this.brightness > 0.85f && world.field_73012_v.nextFloat() < 0.25f) {
            this.brightness -= world.field_73012_v.nextFloat() * 0.05f;
        }
    }

    private void brighten(float target, float rate) {
        if (this.brightness != target) {
            this.brightness += (target - this.brightness) * rate;
            if (Math.abs(target - this.brightness) < 0.01f) {
                this.brightness = target;
            }
        }
    }
}

