/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.List;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.item.DyeableItem;
import me.paulf.fairylights.server.item.LightVariant;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class LightItem
extends BlockItem {
    private final LightBlock light;

    public LightItem(LightBlock light, Item.Properties properties) {
        super((Block)light, properties);
        this.light = light;
    }

    public LightBlock getBlock() {
        return this.light;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return LightVariant.provider(this.light.getVariant());
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74767_n("twinkle")) {
                tooltip.add(new TranslationTextComponent("item.fairyLights.twinkle", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
            }
            if (tag.func_150297_b("colors", 9)) {
                ListNBT colors = tag.func_150295_c("colors", 3);
                for (int i = 0; i < colors.size(); ++i) {
                    tooltip.add(DyeableItem.getColorName(colors.func_186858_c(i)).func_211708_a(TextFormatting.GRAY));
                }
            }
        }
    }
}

