/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.google.common.base.Strings;
import com.google.common.primitives.UnsignedBytes;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import me.paulf.fairylights.util.NBTSerializable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public final class Jingle
implements NBTSerializable {
    private static final Pattern LOWER_UNDERSCORE_CASE = Pattern.compile("[a-z0-9]+(_[a-z0-9]+)*");
    private static final int DEFAULT_LENGTH = 2;
    private String id;
    private String name;
    private String artist;
    private List<PlayTick> ticks;
    private int minNote = -1;
    private int maxNote = -1;

    private Jingle() {
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getArtist() {
        return this.artist;
    }

    public int getLength() {
        int length = 0;
        for (PlayTick playTick : this.ticks) {
            length += playTick.getLength();
        }
        return length;
    }

    public List<PlayTick> getPlayTicks() {
        return this.ticks;
    }

    public int getLowestNote() {
        return this.minNote;
    }

    public int getRange() {
        return this.maxNote - this.minNote + 1;
    }

    public boolean isValid() {
        if (Strings.isNullOrEmpty((String)this.id) || Strings.isNullOrEmpty((String)this.name) || Strings.isNullOrEmpty((String)this.artist)) {
            return false;
        }
        if (!LOWER_UNDERSCORE_CASE.matcher(this.id).matches()) {
            return false;
        }
        if (this.ticks == null || this.ticks.isEmpty()) {
            return false;
        }
        if (this.minNote > this.maxNote || this.minNote < 0) {
            return false;
        }
        for (PlayTick tick : this.ticks) {
            if (tick.length <= 0 || tick.length > 255 || tick.notes == null || tick.notes.length == 0) {
                return false;
            }
            for (int note : tick.notes) {
                if (note >= 0 && note <= 24) continue;
                return false;
            }
        }
        return true;
    }

    private void calculateRange() {
        this.minNote = 24;
        this.maxNote = 0;
        for (PlayTick tick : this.ticks) {
            for (int note : tick.notes) {
                if (note > this.maxNote) {
                    this.maxNote = note;
                }
                if (note >= this.minNote) continue;
                this.minNote = note;
            }
        }
    }

    @Override
    public CompoundNBT serialize() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a("id", this.id);
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("artist", this.artist);
        ListNBT tickList = new ListNBT();
        for (PlayTick tick : this.ticks) {
            CompoundNBT tickCompound = new CompoundNBT();
            int notes = 0;
            for (int note : tick.notes) {
                notes |= 1 << note;
            }
            tickCompound.func_74768_a("notes", notes);
            tickCompound.func_74774_a("length", UnsignedBytes.checkedCast((long)tick.length));
            tickList.add((Object)tickCompound);
        }
        compound.func_218657_a("ticks", (INBT)tickList);
        return compound;
    }

    @Override
    public void deserialize(CompoundNBT compound) {
        this.id = compound.func_74779_i("id");
        this.name = compound.func_74779_i("name");
        this.artist = compound.func_74779_i("artist");
        ListNBT tickList = compound.func_150295_c("ticks", 10);
        this.ticks = new ArrayList<PlayTick>(tickList.size());
        for (int i = 0; i < tickList.size(); ++i) {
            CompoundNBT tickCompound = tickList.func_150305_b(i);
            int noteBits = tickCompound.func_74762_e("notes");
            int[] notes = new int[Integer.bitCount(noteBits)];
            int idx = 0;
            for (int note = 0; note < 25; ++note) {
                if ((noteBits & 1 << note) <= 0) continue;
                notes[idx++] = note;
            }
            int length = tickCompound.func_150297_b("length", 99) ? tickCompound.func_74771_c("length") & 0xFF : 2;
            this.ticks.add(new PlayTick(notes, length));
        }
        this.calculateRange();
    }

    public static Jingle from(CompoundNBT compound) {
        Jingle jingle = new Jingle();
        jingle.deserialize(compound);
        return jingle;
    }

    public static final class PlayTick {
        private final int[] notes;
        private final int length;

        public PlayTick(int[] notes, int length) {
            this.notes = notes;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int[] getNotes() {
            return this.notes;
        }
    }
}

