/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.jingle;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.jingle.Jingle;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.resources.IResource;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DefaultedRegistry;
import net.minecraft.util.registry.Registry;

public class JingleLibrary {
    private static final ResourceLocation DEFAULT_ID = new ResourceLocation("fairylights", "unknown");
    private static final DefaultedRegistry<JingleLibrary> REGISTRY = new DefaultedRegistry(DEFAULT_ID.toString());
    private static final JingleLibrary DEFAULT = JingleLibrary.register(new JingleLibrary(DEFAULT_ID){

        @Override
        public void load(MinecraftServer server) {
        }
    });
    public static final JingleLibrary CHRISTMAS = JingleLibrary.create("christmas");
    public static final JingleLibrary RANDOM = JingleLibrary.create("random");
    private static final int MAX_RANGE = 25;
    private final ResourceLocation name;
    private final Map<String, Jingle> jingles = new HashMap<String, Jingle>();
    private final Multimap<Integer, Jingle> jinglesWithinRange = ArrayListMultimap.create();
    private final Map<Integer, Integer> rangeWeights = new HashMap<Integer, Integer>();

    private JingleLibrary(ResourceLocation name) {
        this.name = name;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public boolean contains(String id) {
        return this.jingles.containsKey(id);
    }

    @Nullable
    public Jingle get(String id) {
        return this.jingles.get(id);
    }

    private void put(String id, Jingle jingle) {
        this.jingles.put(id, jingle);
        for (int range = jingle.getRange(); range <= 25; ++range) {
            this.jinglesWithinRange.put((Object)range, (Object)jingle);
            this.rangeWeights.merge(range, jingle.getRange(), Math::addExact);
        }
    }

    @Nullable
    public Jingle getRandom(Random rng, int range) {
        int fitRange = Math.min(range, 25);
        Collection jingles = this.jinglesWithinRange.get((Object)fitRange);
        if (jingles.isEmpty()) {
            return null;
        }
        float choice = rng.nextFloat() * (float)this.rangeWeights.get(fitRange).intValue();
        for (Jingle jingle : jingles) {
            if (!((choice -= (float)jingle.getRange()) <= 0.0f)) continue;
            return jingle;
        }
        return null;
    }

    public void load(MinecraftServer server) {
        try (IResource resource = server.func_195570_aG().func_199002_a(new ResourceLocation(this.name.func_110624_b(), "/jingles/" + this.name.func_110623_a() + ".dat"));){
            this.deserialize(CompressedStreamTools.func_74796_a((InputStream)resource.func_199027_b()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void deserialize(CompoundNBT library) {
        this.jingles.clear();
        this.jinglesWithinRange.clear();
        this.rangeWeights.clear();
        for (String id : library.func_150296_c()) {
            CompoundNBT jingleCompound = library.func_74775_l(id);
            Jingle jingle = Jingle.from(jingleCompound);
            if (!jingle.isValid() || this.contains(jingle.getId())) continue;
            this.put(jingle.getId(), jingle);
        }
    }

    public static JingleLibrary create(String name) {
        return JingleLibrary.register(new JingleLibrary(new ResourceLocation("fairylights", name)));
    }

    private static JingleLibrary register(JingleLibrary library) {
        return (JingleLibrary)Registry.func_218322_a(REGISTRY, (ResourceLocation)library.name, (Object)library);
    }

    public static JingleLibrary fromName(ResourceLocation name) {
        return (JingleLibrary)REGISTRY.func_82594_a(name);
    }

    public static void loadAll(MinecraftServer server) {
        for (JingleLibrary library : REGISTRY) {
            library.load(server);
        }
    }
}

