/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.serverbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.ServerMessageContext;
import me.paulf.fairylights.util.Utils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.event.ForgeEventFactory;

public final class InteractionConnectionMessage
extends ConnectionMessage {
    private static final float RANGE = 1089.0f;
    private static final float REACH = 36.0f;
    private PlayerAction type;
    private Vec3d hit;
    private FeatureType featureType;
    private int featureId;

    public InteractionConnectionMessage() {
    }

    public InteractionConnectionMessage(Connection connection, PlayerAction type, Intersection intersection) {
        super(connection);
        this.type = type;
        this.hit = intersection.getResult();
        this.featureType = intersection.getFeatureType();
        this.featureId = intersection.getFeature().getId();
    }

    @Override
    public void encode(PacketBuffer buf) {
        super.encode(buf);
        buf.writeByte(this.type.ordinal());
        buf.writeDouble(this.hit.field_72450_a);
        buf.writeDouble(this.hit.field_72448_b);
        buf.writeDouble(this.hit.field_72449_c);
        buf.func_150787_b(this.featureType.getId());
        buf.func_150787_b(this.featureId);
    }

    @Override
    public void decode(PacketBuffer buf) {
        super.decode(buf);
        this.type = Utils.getEnumValue(PlayerAction.class, buf.readUnsignedByte());
        this.hit = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.featureType = FeatureType.fromId(buf.func_150792_a());
        this.featureId = buf.func_150792_a();
    }

    public static final class Handler
    implements BiConsumer<InteractionConnectionMessage, ServerMessageContext> {
        @Override
        public void accept(InteractionConnectionMessage message, ServerMessageContext context) {
            ServerPlayerEntity player = context.getPlayer();
            ConnectionMessage.getConnection(message, c -> true, player.field_70170_p).ifPresent(connection -> {
                if (connection.isModifiable((PlayerEntity)player)) {
                    Vec3d vec3d = new Vec3d((Vec3i)connection.getFastener().getPos());
                    if (player.func_213303_ch().func_72436_e(vec3d) < 1089.0 && player.func_70092_e(((InteractionConnectionMessage)message).hit.field_72450_a, ((InteractionConnectionMessage)message).hit.field_72448_b, ((InteractionConnectionMessage)message).hit.field_72449_c) < 36.0) {
                        if (message.type == PlayerAction.ATTACK) {
                            connection.disconnect((PlayerEntity)player, message.hit);
                        } else {
                            this.interact(message, (PlayerEntity)player, (Connection)connection, message.hit);
                        }
                    }
                }
            });
        }

        private void interact(InteractionConnectionMessage message, PlayerEntity player, Connection connection, Vec3d hit) {
            for (Hand hand : Hand.values()) {
                ItemStack stack = player.func_184586_b(hand);
                ItemStack oldStack = stack.func_77946_l();
                if (!connection.interact(player, hit, message.featureType, message.featureId, stack, hand)) continue;
                this.updateItem(player, oldStack, stack, hand);
                break;
            }
        }

        private void updateItem(PlayerEntity player, ItemStack oldStack, ItemStack stack, Hand hand) {
            if (stack.func_190916_E() <= 0 && !player.field_71075_bZ.field_75098_d) {
                ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)stack, (Hand)hand);
                player.func_184611_a(hand, ItemStack.field_190927_a);
            } else if (stack.func_190916_E() < oldStack.func_190916_E() && player.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(oldStack.func_190916_E());
            }
        }
    }
}

