/*
 * Decompiled with CFR 0.152.
 */
package com.unrelentless.fallfest116.entity;

import com.unrelentless.fallfest116.FallFest116;
import com.unrelentless.fallfest116.block.FallenLeavesBlock;
import com.unrelentless.fallfest116.component.EntityComponents;
import com.unrelentless.fallfest116.component.IntComponent;
import com.unrelentless.fallfest116.mixin.StatusEffectMixin;
import com.unrelentless.fallfest116.util.FallenColour;
import com.unrelentless.fallfest116.util.LeafType;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1400;
import net.minecraft.class_1427;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class GhostEntity
extends class_1427
implements class_1603 {
    private class_1842[] goodPotions = GhostEntity.getPotionsForType(class_4081.field_18271);
    private class_1842[] badPotions = GhostEntity.getPotionsForType(class_4081.field_18272);
    public static final class_2746 FALLED = class_2746.method_11825((String)"falled");
    private static final class_2940<Boolean> SHOOTING = class_2945.method_12791(GhostEntity.class, (class_2941)class_2943.field_13323);

    public GhostEntity(class_1299<? extends class_1427> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createGhostAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23717, 4.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new GhostProjectileAttackGoal(this, 1.25, 60, 2.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0, 1.0000001E-5f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new GhostFollowTargetGoal((class_1308)this, class_1657.class, 10, true, false, livingEntity -> {
            if (livingEntity instanceof class_1657) {
                int value = ((IntComponent)EntityComponents.GHOST_COOLDOWN.get(livingEntity)).getValue();
                return !this.field_6002.method_8530() && value == 0;
            }
            return false;
        }));
    }

    public void method_6007() {
        super.method_6007();
        if (!this.field_6002.field_9236) {
            if (!this.field_6002.method_8450().method_8355(class_1928.field_19388)) {
                return;
            }
            this.spreadFallOnGround();
            this.spreadFallOnTrees();
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (this.field_6002.method_8530() || !stack.method_19267()) {
            return class_1269.field_5812;
        }
        int cooldownValue = ((IntComponent)EntityComponents.GHOST_COOLDOWN.get((Object)player)).getValue();
        if (cooldownValue == 0) {
            float saturation = stack.method_7909().method_19264().method_19231();
            int hunger = stack.method_7909().method_19264().method_19230();
            float aggregateScore = (float)hunger * saturation;
            ((IntComponent)EntityComponents.GHOST_COOLDOWN.get((Object)player)).resetValue();
            this.treatEntity((class_1309)player, aggregateScore);
            stack.method_7934(1);
        } else if (!player.field_6002.field_9236) {
            player.method_7353((class_2561)new class_2585("Cannot trick or treat for another " + cooldownValue / 20 + " seconds."), false);
        }
        return class_1269.field_5812;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOTING, (Object)false);
    }

    public void method_7105(class_1309 target, float pullProgress) {
    }

    protected class_3414 method_5994() {
        return class_3417.field_14736;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15216;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14618;
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    private void treatEntity(class_1309 target, float aggregate) {
        boolean shouldUseBadPotion = aggregate <= 3.0f;
        int randomIndex = (int)(Math.random() * (double)(shouldUseBadPotion ? this.badPotions.length : this.goodPotions.length));
        class_1842 potion = shouldUseBadPotion ? this.badPotions[randomIndex] : this.goodPotions[randomIndex];
        potion.method_8049().forEach(effect -> target.method_26082(effect));
    }

    private void spreadFallOnGround() {
        for (int surroundingBlocks = 0; surroundingBlocks < 4; ++surroundingBlocks) {
            double surroundingOffset = (float)(surroundingBlocks % 2 * 2 - 1) * 0.25f;
            int xPos = class_3532.method_15357((double)(this.method_23317() + surroundingOffset));
            int yPos = class_3532.method_15357((double)this.method_23318());
            int zPos = class_3532.method_15357((double)(this.method_23321() + surroundingOffset));
            class_2338 blockPos = new class_2338(xPos, yPos, zPos);
            class_2680 blockState = (class_2680)((class_2680)FallFest116.FALLEN_LEAVES_BLOCK.method_9564().method_11657(FallenLeavesBlock.TYPE, (Comparable)((Object)LeafType.typeForBiome(this.field_6002.method_23753(blockPos).method_8688())))).method_11657(FallenColour.COLOUR, (Comparable)((Object)FallenColour.COLOURS[new Random().nextInt(3)]));
            if ((!this.field_6002.method_8320(blockPos).method_26215() || !blockState.method_26184((class_4538)this.field_6002, blockPos)) && !this.field_6002.method_8320(blockPos).equals(class_2246.field_10477.method_9564())) continue;
            this.field_6002.method_8501(blockPos, blockState);
        }
    }

    private void spreadFallOnTrees() {
        for (int yPos = 0; yPos < 30; ++yPos) {
            for (int xPos = -4; xPos < 4; ++xPos) {
                for (int zPos = -4; zPos < 4; ++zPos) {
                    int newZPos;
                    int newYPos;
                    int newXPos = class_3532.method_15357((double)this.method_23317()) + xPos;
                    class_2338 newBlockPos = new class_2338(newXPos, newYPos = class_3532.method_15357((double)this.method_23318()) + yPos, newZPos = class_3532.method_15357((double)this.method_23321()) + zPos);
                    class_2680 blockState = this.field_6002.method_8320(newBlockPos);
                    if (!(blockState.method_26204() instanceof class_2397) || ((Boolean)blockState.method_11654((class_2769)FALLED)).booleanValue()) continue;
                    class_2680 newBlockState = (class_2680)((class_2680)blockState.method_11657((class_2769)FALLED, (Comparable)Boolean.valueOf(true))).method_11657(FallenColour.COLOUR, (Comparable)((Object)FallenColour.COLOURS[new Random().nextInt(3)]));
                    this.field_6002.method_8501(newBlockPos, newBlockState);
                }
            }
        }
    }

    private static class_1842[] getPotionsForType(class_4081 type) {
        List potions = class_2378.field_11143.method_29722().stream().map(item -> (class_1842)item.getValue()).filter(potion -> !potion.method_8049().isEmpty()).collect(Collectors.toList());
        class_1842[] filteredPotions = (class_1842[])potions.stream().filter(potion -> ((StatusEffectMixin)((class_1293)potion.method_8049().get(0)).method_5579()).getStatusEffectType().equals((Object)type)).toArray(class_1842[]::new);
        return filteredPotions;
    }

    private class GhostFollowTargetGoal
    extends class_1400<class_1657> {
        public GhostFollowTargetGoal(class_1308 mob, Class<class_1657> targetClass, int reciprocalChance, boolean checkVisibility, boolean checkCanNavigate, Predicate<class_1309> targetPredicate) {
            super(mob, targetClass, reciprocalChance, checkVisibility, checkCanNavigate, targetPredicate);
        }

        public boolean method_6266() {
            int value = ((IntComponent)EntityComponents.GHOST_COOLDOWN.get((Object)this.field_6660.method_5968())).getValue();
            return super.method_6266() && !this.field_6660.field_6002.method_8530() && value == 0;
        }
    }

    private class GhostProjectileAttackGoal
    extends class_1381 {
        private final GhostEntity mob;

        public GhostProjectileAttackGoal(class_1603 mob, double mobSpeed, int intervalTicks, float maxShootRange) {
            super(mob, mobSpeed, intervalTicks, maxShootRange);
            this.mob = (GhostEntity)mob;
        }

        public boolean method_6266() {
            return !this.mob.field_6002.method_8530() && super.method_6266();
        }

        public void method_6269() {
            this.mob.setShooting(true);
            super.method_6269();
        }

        public void method_6270() {
            this.mob.setShooting(false);
            super.method_6270();
        }
    }
}

