/*
 * Decompiled with CFR 0.152.
 */
package nivoridocs.flowstone;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nivoridocs.flowstone.event.LavaExtinguishEvent;

@Mod.EventBusSubscriber
public class FlowstoneEventHandler {
    private static final String LAVA_EXTINGUISH = "block.lava.extinguish";

    @SubscribeEvent
    public static void onEvent(PlaySoundSourceEvent event) {
        if (event.getName().equals(LAVA_EXTINGUISH)) {
            BlockPos pos = FlowstoneEventHandler.createBlockPos((int)event.getSound().func_147649_g(), (int)event.getSound().func_147654_h(), (int)event.getSound().func_147651_i());
            WorldServer world = DimensionManager.getWorld((int)0);
            IBlockState state = world.func_180495_p(pos);
            if (FlowstoneEventHandler.isLavaExtinguishedBlock(state.func_177230_c()) && FlowstoneEventHandler.hasWaterAround((World)world, pos)) {
                MinecraftForge.EVENT_BUS.post((Event)new LavaExtinguishEvent((World)world, pos, state));
            }
        }
    }

    private static boolean isLavaExtinguishedBlock(Block block) {
        return block == Blocks.field_150347_e || block == Blocks.field_150348_b || block == Blocks.field_150343_Z;
    }

    private static BlockPos createBlockPos(int x, int y, int z) {
        return new BlockPos(x < 0 ? x - 1 : x, y, z < 0 ? z - 1 : z);
    }

    private static boolean hasWaterAround(World world, BlockPos pos) {
        return FlowstoneEventHandler.isWater(world, pos.func_177984_a()) || FlowstoneEventHandler.isWater(world, pos.func_177978_c()) || FlowstoneEventHandler.isWater(world, pos.func_177968_d()) || FlowstoneEventHandler.isWater(world, pos.func_177974_f()) || FlowstoneEventHandler.isWater(world, pos.func_177976_e());
    }

    private static boolean isWater(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block == Blocks.field_150355_j || block == Blocks.field_150358_i;
    }
}

