/*
 * Decompiled with CFR 0.152.
 */
package nivoridocs.flowstone.config;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Config;

@Config(modid="flowstone")
@Config.LangKey(value="flowstone.config.title")
public class FlowstoneConfig {
    @Config.RequiresWorldRestart
    public static Map<String, Integer> cobblestone = FlowstoneConfig.defaultForCobblestone();
    @Config.Ignore
    private static Block[] cobblestoneBlock;
    @Config.Ignore
    private static double[] cobblestoneDouble;
    @Config.RequiresWorldRestart
    public static Map<String, Integer> stone;
    @Config.Ignore
    private static Block[] stoneBlock;
    @Config.Ignore
    private static double[] stoneDouble;
    @Config.RequiresWorldRestart
    public static Map<String, Integer> obsidian;
    @Config.Ignore
    private static Block[] obsidianBlock;
    @Config.Ignore
    private static double[] obsidianDouble;

    private static String getName(Block block) {
        return block.getRegistryName().toString();
    }

    private static Map<String, Integer> defaultForCobblestone() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(FlowstoneConfig.getName(Blocks.field_150347_e), 1);
        return map;
    }

    private static Map<String, Integer> defaultForStone() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(FlowstoneConfig.getName(Blocks.field_150348_b), 256);
        map.put(FlowstoneConfig.getName(Blocks.field_150366_p), 64);
        map.put(FlowstoneConfig.getName(Blocks.field_150450_ax), 16);
        map.put(FlowstoneConfig.getName(Blocks.field_150352_o), 4);
        map.put(FlowstoneConfig.getName(Blocks.field_150369_x), 1);
        map.put(FlowstoneConfig.getName(Blocks.field_150482_ag), 1);
        return map;
    }

    private static Map<String, Integer> defaultForObsidian() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put(FlowstoneConfig.getName(Blocks.field_150343_Z), 1);
        return map;
    }

    private static double[] getDistribution(Map<String, Integer> map) {
        double max = map.values().stream().mapToDouble(Integer::doubleValue).sum();
        double[] array = map.keySet().stream().sorted().mapToDouble(map::get).filter(x -> x > 0.0).map(x -> x / max).toArray();
        for (int i = 1; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] + array[i - 1];
        }
        return array;
    }

    private static Block[] getBlocks(Map<String, Integer> map) {
        return (Block[])map.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).map(Map.Entry::getKey).sorted().map(Block::func_149684_b).toArray(Block[]::new);
    }

    private static int getIndex(double[] doubles, Random random) {
        int index = Arrays.binarySearch(doubles, random.nextDouble());
        return index < 0 ? -index - 1 : index;
    }

    private static Optional<Block> randomForCobblestone(Random random) {
        if (cobblestoneBlock == null) {
            cobblestoneBlock = FlowstoneConfig.getBlocks(cobblestone);
        }
        if (cobblestoneDouble == null) {
            cobblestoneDouble = FlowstoneConfig.getDistribution(cobblestone);
        }
        return Optional.of(cobblestoneBlock[FlowstoneConfig.getIndex(cobblestoneDouble, random)]);
    }

    private static Optional<Block> randomForStone(Random random) {
        if (stoneBlock == null) {
            stoneBlock = FlowstoneConfig.getBlocks(stone);
        }
        if (stoneDouble == null) {
            stoneDouble = FlowstoneConfig.getDistribution(stone);
        }
        return Optional.of(stoneBlock[FlowstoneConfig.getIndex(stoneDouble, random)]);
    }

    private static Optional<Block> randomForObsidian(Random random) {
        if (obsidianBlock == null) {
            obsidianBlock = FlowstoneConfig.getBlocks(obsidian);
        }
        if (obsidianDouble == null) {
            obsidianDouble = FlowstoneConfig.getDistribution(obsidian);
        }
        return Optional.of(obsidianBlock[FlowstoneConfig.getIndex(obsidianDouble, random)]);
    }

    public static void reset() {
        cobblestoneBlock = null;
        cobblestoneDouble = null;
        stoneBlock = null;
        stoneDouble = null;
        obsidianBlock = null;
        obsidianDouble = null;
    }

    public static Optional<Block> randomFor(Block block, Random random) {
        Optional<Object> result = Optional.empty();
        if (block == Blocks.field_150347_e) {
            result = FlowstoneConfig.randomForCobblestone(random);
        }
        if (block == Blocks.field_150348_b) {
            result = FlowstoneConfig.randomForStone(random);
        }
        if (block == Blocks.field_150343_Z) {
            result = FlowstoneConfig.randomForObsidian(random);
        }
        return result.filter(x -> x != block);
    }

    static {
        stone = FlowstoneConfig.defaultForStone();
        obsidian = FlowstoneConfig.defaultForObsidian();
    }
}

