/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.minecraft.fluidphysics.mixin;

import de.lolhens.minecraft.fluidphysics.FluidPhysicsMod;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeColors.class})
public class BiomeColorsMixin {
    @Inject(at={@At(value="HEAD")}, method={"getWaterColor"}, cancellable=true)
    private static void getWaterColor(IBlockDisplayReader view, BlockPos pos, CallbackInfoReturnable<Integer> info) {
        if (FluidPhysicsMod.config().getDebugFluidState()) {
            int r = 0;
            int g = 0;
            int b = 0;
            try {
                FluidState state = ((FlowingFluidBlock)Blocks.field_150355_j).func_204507_t(view.func_180495_p(pos));
                r = 31 * state.func_206882_g();
                g = state.func_206889_d() ? 255 : 0;
                b = (Boolean)state.func_177229_b((Property)FlowingFluid.field_207209_a) != false ? 255 : 0;
            }
            catch (Exception state) {
                // empty catch block
            }
            int color = r << 16 | g << 8 | b;
            info.setReturnValue((Object)color);
        }
    }
}

