/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.minecraft.fluidphysics.mixin;

import de.lolhens.minecraft.fluidphysics.FluidPhysicsMod;
import de.lolhens.minecraft.fluidphysics.mixin.FlowableFluidAccessor;
import de.lolhens.minecraft.fluidphysics.util.FluidIsInfinite;
import de.lolhens.minecraft.fluidphysics.util.FluidSourceFinder;
import net.minecraft.block.BlockState;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import scala.Option;

@Mixin(value={FlowingFluid.class})
public abstract class FlowableFluidMixin
implements FlowableFluidAccessor {
    @Shadow
    protected abstract boolean func_211758_g(FluidState var1);

    private boolean canFlowDownIntoTrapdoor(BlockState state) {
        FlowingFluid fluid = (FlowingFluid)this;
        if (fluid.func_207187_a((Fluid)Fluids.field_204546_a) && state.func_177230_c() instanceof TrapDoorBlock) {
            return (Boolean)state.func_177229_b((Property)TrapDoorBlock.field_204614_t) == false && (state.func_177229_b((Property)TrapDoorBlock.field_176285_M) == Half.BOTTOM || (Boolean)state.func_177229_b((Property)TrapDoorBlock.field_176283_b) != false);
        }
        return false;
    }

    @Inject(at={@At(value="RETURN")}, method={"func_211759_a"}, cancellable=true)
    private void func_211759_a(IBlockReader world, Fluid fluid, BlockPos pos, BlockState state, BlockPos fromPos, BlockState fromState, CallbackInfoReturnable<Boolean> info) {
        FluidState fluidState;
        if (this.canFlowDownIntoTrapdoor(fromState)) {
            info.setReturnValue((Object)true);
        } else if (((Boolean)info.getReturnValue()).booleanValue() && FluidPhysicsMod.config().enabledFor(fluid) && FluidPhysicsMod.config().getFlowOverSources() && this.func_211758_g(fluidState = fromState.func_204520_s())) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"canFlow"}, cancellable=true)
    protected void canFlow(IBlockReader world, BlockPos fluidPos, BlockState fluidBlockState, Direction flowDirection, BlockPos flowTo, BlockState flowToBlockState, FluidState fluidState, Fluid fluid, CallbackInfoReturnable<Boolean> info) {
        if (flowDirection == Direction.DOWN && FluidPhysicsMod.config().enabledFor(fluid)) {
            if (((FlowingFluid)this).func_207187_a(fluidState.func_206886_c()) && !fluidState.func_206889_d()) {
                info.setReturnValue((Object)true);
            } else if (this.canFlowDownIntoTrapdoor(flowToBlockState)) {
                info.setReturnValue((Object)true);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"calculateCorrectFlowingState"})
    protected void calculateCorrectFlowingState(IWorldReader world, BlockPos pos, BlockState state, CallbackInfoReturnable<FluidState> info) {
        FluidIsInfinite.set(world, pos);
    }

    @Shadow
    public abstract FluidState func_207204_a(boolean var1);

    @Shadow
    public abstract FluidState func_207207_a(int var1, boolean var2);

    @Inject(at={@At(value="HEAD")}, method={"flowInto"}, cancellable=true)
    protected void flowInto(IWorld world, BlockPos pos, BlockState state, Direction direction, FluidState fluidState, CallbackInfo info) {
        FluidState still = this.func_207204_a(false);
        if (!FluidPhysicsMod.config().enabledFor(still.func_206886_c())) {
            return;
        }
        BlockPos up = pos.func_177984_a();
        if (direction == Direction.DOWN || world.func_204610_c(up).func_206886_c().func_207187_a(still.func_206886_c())) {
            boolean isFlowingOntoPiston;
            BlockState blockStateBelow = world.func_180495_p(pos.func_177977_b());
            boolean bl = isFlowingOntoPiston = blockStateBelow.func_177230_c() instanceof PistonBlock && blockStateBelow.func_177229_b((Property)DirectionalBlock.field_176387_N) == Direction.UP;
            if (isFlowingOntoPiston) {
                return;
            }
            Option<BlockPos> sourcePos = FluidSourceFinder.findSource(world, up, still.func_206886_c());
            if (sourcePos.isDefined()) {
                int newSourceLevel = still.func_206882_g() - 1;
                FluidState newSourceFluidState = this.func_207207_a(newSourceLevel, false);
                BlockState sourceState = world.func_180495_p((BlockPos)sourcePos.get());
                if (sourceState.func_177230_c() instanceof IBucketPickupHandler && !(sourceState.func_177230_c() instanceof FlowingFluidBlock)) {
                    ((IBucketPickupHandler)sourceState.func_177230_c()).func_204508_a(world, (BlockPos)sourcePos.get(), sourceState);
                } else {
                    if (!sourceState.func_177230_c().isAir(sourceState, (IBlockReader)world, (BlockPos)sourcePos.get())) {
                        this.callBeforeReplacingBlock(world, (BlockPos)sourcePos.get(), sourceState);
                    }
                    world.func_180501_a((BlockPos)sourcePos.get(), newSourceFluidState.func_206883_i(), 3);
                }
                if (state.func_177230_c() instanceof ILiquidContainer) {
                    ((ILiquidContainer)state.func_177230_c()).func_204509_a(world, pos, state, still);
                } else {
                    if (!state.func_177230_c().isAir(state, (IBlockReader)world, pos)) {
                        this.callBeforeReplacingBlock(world, pos, state);
                    }
                    world.func_180501_a(pos, still.func_206883_i(), 3);
                }
                info.cancel();
            }
        }
    }
}

