/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.minecraft.fluidphysics.mixin;

import de.lolhens.minecraft.fluidphysics.FluidPhysicsMod;
import de.lolhens.minecraft.fluidphysics.mixin.FlowableFluidAccessor;
import de.lolhens.minecraft.fluidphysics.util.FluidSourceFinder;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.PistonBlock;
import net.minecraft.block.PistonBlockStructureHelper;
import net.minecraft.block.material.PushReaction;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import scala.Option;

@Mixin(value={PistonBlock.class})
public abstract class PistonBlockMixin {
    @Inject(at={@At(value="HEAD")}, method={"canPush"}, cancellable=true)
    private static void canPush(BlockState state, World world, BlockPos pos, Direction motionDir, boolean canBreak, Direction pistonDir, CallbackInfoReturnable<Boolean> info) {
        BlockPos nextBlockPos;
        BlockState nextBlockState;
        FluidState fluidState = state.func_204520_s();
        if (!fluidState.func_206888_e() && FluidPhysicsMod.config().enabledFor(fluidState.func_206886_c()) && fluidState.func_206889_d() && !(nextBlockState = world.func_180495_p(nextBlockPos = pos.func_177972_a(motionDir))).isAir((IBlockReader)world, nextBlockPos) && !nextBlockState.func_204520_s().func_206886_c().func_207187_a(fluidState.func_206886_c()) && nextBlockState.func_185905_o() != PushReaction.DESTROY) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"doMove"}, cancellable=true)
    private void doMove(World world, BlockPos pos, Direction dir, boolean retract, CallbackInfoReturnable<Boolean> info) {
        PistonBlockStructureHelper pistonHandler;
        BlockPos blockPos = pos.func_177972_a(dir);
        if (!retract && world.func_180495_p(blockPos).func_203425_a(Blocks.field_150332_K)) {
            world.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 20);
        }
        if (!(pistonHandler = new PistonBlockStructureHelper(world, pos, dir, retract)).func_177253_a()) {
            info.setReturnValue((Object)false);
        } else {
            Direction oppositeDir = dir.func_176734_d();
            HashSet<BlockPos> blockPosSet = new HashSet<BlockPos>();
            blockPosSet.add(blockPos);
            for (BlockPos movedBlockPos : pistonHandler.func_177254_c()) {
                blockPosSet.add(movedBlockPos);
                blockPosSet.add(movedBlockPos.func_177972_a(dir));
            }
            for (BlockPos currentBlockPos : blockPosSet) {
                BlockState blockState = world.func_180495_p(currentBlockPos);
                FluidState fluidState = blockState.func_204520_s();
                if (fluidState.func_206888_e() || !FluidPhysicsMod.config().enabledFor(fluidState.func_206886_c()) || !(fluidState.func_206886_c() instanceof FlowingFluid) || fluidState.func_206889_d()) continue;
                FlowingFluid fluid = (FlowingFluid)fluidState.func_206886_c();
                Option<BlockPos> sourcePos = FluidSourceFinder.findSource((IWorld)world, currentBlockPos, fluidState.func_206886_c(), oppositeDir, FluidSourceFinder.setOf(blockPosSet), true, true);
                if (!sourcePos.isDefined()) continue;
                FluidState still = fluid.func_207204_a(false);
                int newSourceLevel = still.func_206882_g() - 1;
                FluidState newSourceFluidState = fluid.func_207207_a(newSourceLevel, false);
                BlockState sourceState = world.func_180495_p((BlockPos)sourcePos.get());
                if (sourceState.func_177230_c() instanceof IBucketPickupHandler && !(sourceState.func_177230_c() instanceof FlowingFluidBlock)) {
                    ((IBucketPickupHandler)sourceState.func_177230_c()).func_204508_a((IWorld)world, (BlockPos)sourcePos.get(), sourceState);
                } else {
                    if (!sourceState.isAir((IBlockReader)world, (BlockPos)sourcePos.get())) {
                        ((FlowableFluidAccessor)fluid).callBeforeReplacingBlock((IWorld)world, (BlockPos)sourcePos.get(), sourceState);
                    }
                    world.func_180501_a((BlockPos)sourcePos.get(), newSourceFluidState.func_206883_i(), 3);
                }
                if (fluidState.func_206883_i().func_177230_c() instanceof ILiquidContainer) {
                    ((ILiquidContainer)blockState.func_177230_c()).func_204509_a((IWorld)world, currentBlockPos, blockState, still);
                    continue;
                }
                if (!blockState.isAir((IBlockReader)world, currentBlockPos)) {
                    ((FlowableFluidAccessor)fluid).callBeforeReplacingBlock((IWorld)world, currentBlockPos, blockState);
                }
                world.func_180501_a(currentBlockPos, still.func_206883_i(), 3);
            }
        }
    }
}

