/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.minecraft.fluidphysics.util;

import de.lolhens.minecraft.fluidphysics.FluidPhysicsMod$;
import de.lolhens.minecraft.fluidphysics.package$;
import java.io.Serializable;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class FluidSourceFinder$ {
    public static final FluidSourceFinder$ MODULE$ = new FluidSourceFinder$();

    private int defaultMaxIterations() {
        return BoxesRunTime.unboxToInt((Object)FluidPhysicsMod$.MODULE$.config().findSourceMaxIterations().value());
    }

    public Set<BlockPos> setOf(Collection<BlockPos> blockPos) {
        return (Set)CollectionConverters$.MODULE$.CollectionHasAsScala(blockPos).asScala().to(IterableFactory$.MODULE$.toFactory((IterableFactory)Set$.MODULE$));
    }

    public Option<BlockPos> findSource(IWorld world, BlockPos blockPos, Fluid fluid) {
        return this.findSource(world, blockPos, fluid, Direction.UP);
    }

    public Option<BlockPos> findSource(IWorld world, BlockPos blockPos, Fluid fluid, Direction direction) {
        return this.findSource(world, blockPos, fluid, direction, (Set<BlockPos>)((Set)Set$.MODULE$.empty()), false, false, this.defaultMaxIterations());
    }

    public Option<BlockPos> findSource(IWorld world, BlockPos blockPos, Fluid fluid, Direction direction, Set<BlockPos> ignoreBlocks, boolean ignoreFirst, boolean ignoreLevel) {
        return this.findSource(world, blockPos, fluid, direction, ignoreBlocks, ignoreFirst, ignoreLevel, this.defaultMaxIterations());
    }

    public Option<BlockPos> findSource(IWorld world, BlockPos blockPos, Fluid fluid, Direction direction, Set<BlockPos> ignoreBlocks, boolean ignoreFirst, boolean ignoreLevel, int maxIterations) {
        return this.findSourceInternal(world, blockPos, world.func_204610_c(blockPos), fluid, direction, ignoreBlocks, ignoreFirst, ignoreLevel, maxIterations, 0);
    }

    private Option<BlockPos> findSourceInternal(IWorld world, BlockPos blockPos, FluidState fluidState, Fluid fluid, Direction direction2, Set<BlockPos> ignoreBlocks, boolean ignoreFirst, boolean ignoreLevel, int maxIterations, int iteration) {
        if (iteration > maxIterations || FluidPhysicsMod$.MODULE$.config().findSourceMaxCheckedBlocks().value().exists((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> ignoreBlocks.size() >= x$1)) {
            return None$.MODULE$;
        }
        if (!ignoreFirst && ignoreBlocks.contains((Object)blockPos)) {
            return None$.MODULE$;
        }
        ignoreBlocks.add((Object)blockPos);
        if (!fluidState.func_206888_e() && fluid.func_207187_a(fluidState.func_206886_c())) {
            Option<BlockPos> sourcePos;
            BlockPos up;
            FluidState upFluidState;
            Direction direction3 = direction2;
            Direction direction4 = Direction.DOWN;
            if ((direction3 == null ? direction4 != null : !direction3.equals(direction4)) && !(upFluidState = world.func_204610_c(up = blockPos.func_177984_a())).func_206888_e() && fluid.func_207187_a(upFluidState.func_206886_c()) && (sourcePos = this.findSourceInternal(world, up, upFluidState, fluid, Direction.UP, ignoreBlocks, false, false, maxIterations, iteration + 1)).isDefined()) {
                return sourcePos;
            }
            Direction oppositeDirection = direction2.func_176734_d();
            if (!ignoreFirst && fluidState.func_206889_d()) {
                boolean bl;
                Option option = FluidPhysicsMod$.MODULE$.config().spring().map((Function1 & Serializable)x$2 -> x$2.getBlock());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Block springBlock = (Block)some.value();
                    bl = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.horizontal()), (Object)Direction.DOWN, ClassTag$.MODULE$.apply(Direction.class))), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FluidSourceFinder$.$anonfun$findSourceInternal$3(oppositeDirection, x$3)))), (Function1 & Serializable)direction -> BoxesRunTime.boxToBoolean((boolean)FluidSourceFinder$.$anonfun$findSourceInternal$4(world, blockPos, springBlock, direction)));
                } else if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else {
                    throw new MatchError((Object)option);
                }
                boolean nextToSpring = bl;
                if (!nextToSpring) {
                    return new Some((Object)blockPos);
                }
            }
            Boolean falling = (Boolean)fluidState.func_177229_b((Property)FlowingFluid.field_207209_a);
            for (int i = 0; i < package$.MODULE$.horizontal().length; ++i) {
                Option<BlockPos> sourcePos2;
                Direction nextDirection;
                Direction direction5 = nextDirection = package$.MODULE$.horizontal()[i];
                Direction direction6 = oppositeDirection;
                if (!(direction5 == null ? direction6 != null : !direction5.equals(direction6))) continue;
                int level = fluidState.func_206882_g();
                BlockPos nextBlockPos = blockPos.func_177972_a(nextDirection);
                FluidState nextFluidState = world.func_204610_c(nextBlockPos);
                if (nextFluidState.func_206888_e()) continue;
                int nextLevel = nextFluidState.func_206882_g();
                Boolean nextFalling = (Boolean)nextFluidState.func_177229_b((Property)FlowingFluid.field_207209_a);
                if (nextLevel <= level && (!Predef$.MODULE$.Boolean2boolean(falling) || Predef$.MODULE$.Boolean2boolean(nextFalling)) && !ignoreLevel || !(sourcePos2 = this.findSourceInternal(world, nextBlockPos, nextFluidState, fluid, nextDirection, ignoreBlocks, false, ignoreLevel, maxIterations, iteration + 1)).isDefined()) continue;
                return sourcePos2;
            }
        }
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$findSourceInternal$3(Direction oppositeDirection$1, Direction x$3) {
        Direction direction = x$3;
        Direction direction2 = oppositeDirection$1;
        return !(direction != null ? !direction.equals(direction2) : direction2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findSourceInternal$4(IWorld world$1, BlockPos blockPos$1, Block springBlock$1, Direction direction) {
        return world$1.func_180495_p(blockPos$1.func_177972_a(direction)).func_203425_a(springBlock$1);
    }

    private FluidSourceFinder$() {
    }
}

