/*
 * Decompiled with CFR 0.152.
 */
package de.lolhens.minecraft.fluidphysics.util;

import de.lolhens.minecraft.fluidphysics.FluidPhysicsMod$;
import de.lolhens.minecraft.fluidphysics.config.FluidPhysicsConfig;
import de.lolhens.minecraft.fluidphysics.mixin.ThreadedAnvilChunkStorageAccessor;
import de.lolhens.minecraft.fluidphysics.package$;
import java.io.Serializable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class RainRefill$ {
    public static final RainRefill$ MODULE$ = new RainRefill$();
    private static int maxLevel;
    private static volatile boolean bitmap$0;

    public void init() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Tuple2 tuple2 = new Tuple2((Object)event.phase, (Object)event.world);
            if (tuple2 != null) {
                TickEvent.Phase phase = (TickEvent.Phase)tuple2._1();
                World serverWorld = (World)tuple2._2();
                if (TickEvent.Phase.END.equals(phase) && serverWorld instanceof ServerWorld) {
                    ServerWorld serverWorld2 = (ServerWorld)serverWorld;
                    MODULE$.refillInLoadedChunks(serverWorld2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private int maxLevel$lzycompute() {
        RainRefill$ rainRefill$ = this;
        synchronized (rainRefill$) {
            if (!bitmap$0) {
                maxLevel = 33 + ChunkStatus.func_222599_a((ChunkStatus)ChunkStatus.field_222617_m);
                bitmap$0 = true;
            }
        }
        return maxLevel;
    }

    private int maxLevel() {
        return !bitmap$0 ? this.maxLevel$lzycompute() : maxLevel;
    }

    private Seq<ChunkPos> loadedChunks(ServerWorld serverWorld) {
        ServerChunkProvider chunkManager = serverWorld.func_72863_F();
        return ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.IterableHasAsScala(((ThreadedAnvilChunkStorageAccessor)chunkManager.field_217237_a).callGetLoadedChunksIterable()).asScala().filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RainRefill$.$anonfun$loadedChunks$1(x$1)))).map((Function1 & Serializable)x$2 -> x$2.func_219277_h())).toSeq();
    }

    public int refillInLoadedChunks(ServerWorld world) {
        int n;
        Object object = new Object();
        try {
            if (world.func_72896_J()) {
                FluidPhysicsMod$.MODULE$.config().rainRefill().foreach((Function1 & Serializable)rainRefillOptions -> {
                    long startTime = System.currentTimeMillis();
                    Seq<ChunkPos> chunks = MODULE$.loadedChunks(world);
                    chunks.foreach((Function1 & Serializable)chunkPos -> {
                        RainRefill$.MODULE$.refillInChunk(world, chunkPos, rainRefillOptions);
                        return BoxedUnit.UNIT;
                    });
                    throw new NonLocalReturnControl.mcI.sp(object, (int)(System.currentTimeMillis() - startTime));
                });
            }
            n = 0;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    private BlockPos getHighestBlock(Chunk chunk, int chunkX, int chunkZ) {
        int y = chunk.func_217303_b(Heightmap.Type.WORLD_SURFACE).func_202273_a(chunkX, chunkZ);
        return new BlockPos(chunk.func_76632_l().func_180334_c() + chunkX, y, chunk.func_76632_l().func_180333_d() + chunkZ);
    }

    private boolean shouldRefill(World world, BlockPos blockPos, BlockState blockState, FluidState fluidState, FlowingFluid fluid, FluidPhysicsConfig.RainRefillConfig rainRefillOptions) {
        boolean bl;
        if (!fluidState.func_206889_d() && rainRefillOptions.canRainAt(world, blockPos)) {
            List sourceDirections = RainRefill$.onlySources$1((IterableOnce)ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.horizontal())), (Function1 & Serializable)x$1 -> blockPos.func_177972_a(x$1), world, fluid);
            List edgeSources = RainRefill$.onlySources$1((IterableOnce)sourceDirections.iterator().flatMap((Function1 & Serializable)dir -> {
                BlockPos pos = blockPos.func_177972_a(dir);
                return (List)new .colon.colon((Object)pos.func_177972_a(dir.func_176746_e()), (List)new .colon.colon((Object)pos.func_177972_a(dir.func_176735_f()), (List)Nil$.MODULE$));
            }).distinct(), (Function1 & Serializable)x -> (BlockPos)Predef$.MODULE$.identity(x), world, fluid);
            int numSources = sourceDirections.size() + edgeSources.size();
            bl = numSources >= 2;
        } else {
            bl = false;
        }
        return bl;
    }

    private void runWithProbability(double probability, Function0<BoxedUnit> f) {
        int intProbability = (int)probability;
        int count = intProbability + (Random$.MODULE$.nextDouble() < probability - (double)intProbability ? 1 : 0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$3 -> {
            int n = x$3;
            f.apply$mcV$sp();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    private void refillInChunk(ServerWorld world, ChunkPos chunkPos, FluidPhysicsConfig.RainRefillConfig rainRefillOptions) {
        LazyRef chunk$lzy = new LazyRef();
        this.runWithProbability(BoxesRunTime.unboxToDouble((Object)rainRefillOptions.probability().value()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            BlockPos blockPos = MODULE$.getHighestBlock(RainRefill$.chunk$1(chunk$lzy, world, chunkPos), Random$.MODULE$.nextInt(16), Random$.MODULE$.nextInt(16)).func_177977_b();
            BlockState blockState = world.func_180495_p(blockPos);
            FluidState fluidState = blockState.func_204520_s();
            Fluid fluid = fluidState.func_206886_c();
            if (fluid instanceof FlowingFluid) {
                FlowingFluid flowingFluid = (FlowingFluid)fluid;
                if (!fluidState.func_206888_e() && fluidState.func_206883_i().func_203425_a(blockState.func_177230_c())) {
                    BoxedUnit boxedUnit;
                    if (rainRefillOptions.canRefillFluid((Fluid)flowingFluid) && MODULE$.shouldRefill((World)world, blockPos, blockState, fluidState, flowingFluid, rainRefillOptions)) {
                        FluidState still = flowingFluid.func_207204_a(false);
                        world.func_175656_a(blockPos, still.func_206883_i());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$loadedChunks$1(ChunkHolder x$1) {
        return x$1.func_219281_j() > MODULE$.maxLevel();
    }

    public static final /* synthetic */ boolean $anonfun$shouldRefill$1(World world$2, Function1 pos$1, FlowingFluid fluid$1, Object e) {
        FluidState fluidState = world$2.func_204610_c((BlockPos)pos$1.apply(e));
        return fluid$1.func_207187_a(fluidState.func_206886_c()) && fluidState.func_206889_d();
    }

    private static final List onlySources$1(IterableOnce iterable, Function1 pos, World world$2, FlowingFluid fluid$1) {
        return iterable.iterator().filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)RainRefill$.$anonfun$shouldRefill$1(world$2, pos, fluid$1, e))).toList();
    }

    private static final /* synthetic */ Chunk chunk$lzycompute$1(LazyRef chunk$lzy$1, ServerWorld world$3, ChunkPos chunkPos$1) {
        Chunk chunk;
        LazyRef lazyRef = chunk$lzy$1;
        synchronized (lazyRef) {
            chunk = chunk$lzy$1.initialized() ? (Chunk)chunk$lzy$1.value() : (Chunk)chunk$lzy$1.initialize((Object)world$3.func_212866_a_(chunkPos$1.field_77276_a, chunkPos$1.field_77275_b));
        }
        return chunk;
    }

    private static final Chunk chunk$1(LazyRef chunk$lzy$1, ServerWorld world$3, ChunkPos chunkPos$1) {
        return chunk$lzy$1.initialized() ? (Chunk)chunk$lzy$1.value() : RainRefill$.chunk$lzycompute$1(chunk$lzy$1, world$3, chunkPos$1);
    }

    private RainRefill$() {
    }
}

