/*
 * Decompiled with CFR 0.152.
 */
package com.flysword.entity;

import com.flysword.key.ModKeys;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySword
extends EntityLiving {
    private static final DataParameter<ItemStack> SWORD_ITEM_STACK = EntityDataManager.func_187226_a(EntitySword.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<Byte> CONTROL_STATE = EntityDataManager.func_187226_a(EntitySword.class, (DataSerializer)DataSerializers.field_187191_a);
    private ItemStack renderItemStack;

    public EntitySword(World worldIn) {
        super(worldIn);
        this.func_184224_h(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWORD_ITEM_STACK, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(CONTROL_STATE, (Object)0);
    }

    public void setItemStack(ItemStack itemStack) {
        this.field_70180_af.func_187227_b(SWORD_ITEM_STACK, (Object)itemStack);
    }

    public ItemStack getItemStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(SWORD_ITEM_STACK);
    }

    public ItemStack getRenderItemStack() {
        if (this.renderItemStack == null) {
            this.renderItemStack = new ItemStack(this.getItemStack().func_77973_b());
        }
        return this.renderItemStack;
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("RenderItem", 10)) {
            this.setItemStack(new ItemStack(compound.func_74775_l("RenderItem")));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (!this.getItemStack().func_190926_b()) {
            compound.func_74782_a("RenderItem", (NBTBase)this.getItemStack().func_77955_b(new NBTTagCompound()));
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    private EntityPlayer getControllingPlayer() {
        Entity entity = this.func_184179_bs();
        if (entity instanceof EntityPlayer) {
            return (EntityPlayer)this.func_184179_bs();
        }
        return null;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)passenger;
            this.field_70761_aq = entityliving.field_70761_aq;
        }
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        damageMultiplier = 0.0f;
        super.func_180430_e(distance, damageMultiplier);
    }

    private boolean isRidingPlayer(EntityPlayer player) {
        return this.func_184207_aI() && this.func_184179_bs() == player;
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.isRidingPlayer(player)) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.getItemStack(), 0.0f);
            }
        }
        return true;
    }

    public void func_70071_h_() {
        EntityPlayer player = this.getControllingPlayer();
        if (player != null && player.func_70093_af()) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(this.getItemStack(), 0.0f);
            }
            return;
        }
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateClientControls();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClientControls() {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.isRidingPlayer((EntityPlayer)mc.field_71439_g)) {
            this.up(mc.field_71474_y.field_74314_A.func_151470_d());
            this.down(ModKeys.sKeyFlySwordDown.func_151470_d());
        }
    }

    private boolean up() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) & 1) == 1;
    }

    private boolean down() {
        return ((Byte)this.field_70180_af.func_187225_a(CONTROL_STATE) >> 1 & 1) == 1;
    }

    private void up(boolean up) {
        this.setStateField(0, up);
    }

    private void down(boolean down) {
        this.setStateField(1, down);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_70180_af.func_187225_a(CONTROL_STATE);
        if (newState) {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_70180_af.func_187227_b(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        EntityPlayer player;
        if (this.func_184207_aI() && (player = this.getControllingPlayer()) != null) {
            if (this.down()) {
                this.field_70181_x -= (double)0.03f;
            }
            if (this.up()) {
                this.field_70181_x += (double)0.03f;
            }
            this.field_70126_B = this.field_70177_z = player.field_70177_z;
            this.field_70125_A = player.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            strafe = player.field_70702_br * 0.5f;
            forward = player.field_191988_bg;
            if (forward <= 0.0f) {
                forward *= 0.25f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw()) {
                this.func_70659_e(player.func_70689_ay() * 2.0f);
                this.doTravel(strafe, vertical, forward);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70747_aH = 0.02f;
            this.doTravel(strafe, vertical, forward);
        }
    }

    private void doTravel(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else {
            this.func_191958_b(strafe, vertical, forward, this.field_70747_aH);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }
}

