/*
 * Decompiled with CFR 0.152.
 */
package cazador.furnaceoverhaul;

import cazador.furnaceoverhaul.handler.GuiHandler;
import cazador.furnaceoverhaul.init.ModObjects;
import cazador.furnaceoverhaul.net.MessageSyncTE;
import cazador.furnaceoverhaul.tile.TileEntityDiamondFurnace;
import cazador.furnaceoverhaul.tile.TileEntityEmeraldFurnace;
import cazador.furnaceoverhaul.tile.TileEntityEndFurnace;
import cazador.furnaceoverhaul.tile.TileEntityGoldFurnace;
import cazador.furnaceoverhaul.tile.TileEntityIronFurnace;
import cazador.furnaceoverhaul.tile.TileEntityZenithFurnace;
import cazador.furnaceoverhaul.utils.OreProcessingRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="furnaceoverhaul", name="Furnace Overhaul", version="2.2.2", acceptedMinecraftVersions="[1.12.2]")
public class FurnaceOverhaul {
    public static final String MODID = "furnaceoverhaul";
    public static final String MODNAME = "Furnace Overhaul";
    public static final String VERSION = "2.2.2";
    public static final Logger LOGGER = LogManager.getLogger((String)"furnaceoverhaul");
    public static Object2IntMap<String> FLUID_FUELS = new Object2IntOpenHashMap();
    @Mod.Instance
    public static FurnaceOverhaul INSTANCE;
    public static final SimpleNetworkWrapper NETWORK;
    public static final CreativeTabs FO_TAB;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String[] fuels;
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)new GuiHandler());
        NETWORK.registerMessage(MessageSyncTE.Handler.class, MessageSyncTE.class, 0, Side.CLIENT);
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        for (String s : fuels = cfg.getStringList("Fluid Fuels", "general", new String[]{"lava@20"}, "A list a fluid fuels, in the format name@time, where time is burn ticks per millibucket.")) {
            String[] split = s.split("@");
            if (split.length != 2) {
                LOGGER.info("Ignoring invalid fluid fuel config entry {}!", (Object)s);
                continue;
            }
            try {
                FLUID_FUELS.put((Object)split[0], Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                LOGGER.info("Ignoring invalid fluid fuel config entry {}!", (Object)s);
            }
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerTileEntity(TileEntityIronFurnace.class, (ResourceLocation)ModObjects.IRON_FURNACE.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityGoldFurnace.class, (ResourceLocation)ModObjects.GOLD_FURNACE.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityDiamondFurnace.class, (ResourceLocation)ModObjects.DIAMOND_FURNACE.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityEmeraldFurnace.class, (ResourceLocation)ModObjects.EMERALD_FURNACE.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityEndFurnace.class, (ResourceLocation)ModObjects.END_FURNACE.getRegistryName());
        GameRegistry.registerTileEntity(TileEntityZenithFurnace.class, (ResourceLocation)ModObjects.ZENITH_FURNACE.getRegistryName());
    }

    @Mod.EventHandler
    public void postInit(FMLLoadCompleteEvent event) {
        OreProcessingRegistry.registerDefaults();
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        FO_TAB = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return new ItemStack((Block)ModObjects.IRON_FURNACE);
            }
        };
    }
}

